/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.GroupBindingService;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.MessagingSubsystemAdd;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.dmr.ModelNode;

class MessagingSubsystemRemove
implements OperationStepHandler,
DescriptionProvider {
    static final MessagingSubsystemRemove INSTANCE = new MessagingSubsystemRemove();

    MessagingSubsystemRemove() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final Resource resource = context.removeResource(PathAddress.EMPTY_ADDRESS);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                for (Resource.ResourceEntry jmsQueue : resource.getChildren("jms-queue")) {
                    context.removeService(JMSServices.JMS_QUEUE_BASE.append(new String[]{jmsQueue.getName()}));
                }
                for (Resource.ResourceEntry jmsTopic : resource.getChildren("jms-topic")) {
                    context.removeService(JMSServices.JMS_TOPIC_BASE.append(new String[]{jmsTopic.getName()}));
                }
                for (Resource.ResourceEntry cf : resource.getChildren("connection-factory")) {
                    context.removeService(JMSServices.JMS_CF_BASE.append(new String[]{cf.getName()}));
                }
                for (Resource.ResourceEntry pcf : resource.getChildren("pooled-connection-factory")) {
                    context.removeService(MessagingServices.POOLED_CONNECTION_FACTORY_BASE.append(new String[]{pcf.getName()}));
                }
                for (Resource.ResourceEntry queue : resource.getChildren("queue")) {
                    context.removeService(MessagingServices.CORE_QUEUE_BASE.append(new String[]{queue.getName()}));
                }
                context.removeService(JMSServices.JMS_MANAGER);
                context.removeService(MessagingServices.JBOSS_MESSAGING);
                for (Resource.ResourceEntry broadcastGroup : resource.getChildren("broadcast-group")) {
                    context.removeService(GroupBindingService.BROADCAST.append(new String[]{broadcastGroup.getName()}));
                }
                for (Resource.ResourceEntry divertGroup : resource.getChildren("discovery-group")) {
                    context.removeService(GroupBindingService.DISCOVERY.append(new String[]{divertGroup.getName()}));
                }
                context.removeService(MessagingSubsystemAdd.PATH_BASE.append(new String[]{"bindings"}));
                context.removeService(MessagingSubsystemAdd.PATH_BASE.append(new String[]{"journal"}));
                context.removeService(MessagingSubsystemAdd.PATH_BASE.append(new String[]{"largemessages"}));
                context.removeService(MessagingSubsystemAdd.PATH_BASE.append(new String[]{"paging"}));
                context.completeStep();
            }
        }, OperationContext.Stage.RUNTIME);
        if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
            // empty if block
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getSubsystemRemove(locale);
    }
}

