/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Locale;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

class SecuritySettingRemove
extends AbstractRemoveStepHandler
implements DescriptionProvider {
    static final SecuritySettingRemove INSTANCE = new SecuritySettingRemove();

    SecuritySettingRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        HornetQServer server = SecuritySettingRemove.getServer(context);
        if (server != null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String match = address.getLastElement().getValue();
            server.getSecurityRepository().removeMatch(match);
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getSecuritySettingRemove(locale);
    }

    static HornetQServer getServer(OperationContext context) {
        ServiceController controller = context.getServiceRegistry(true).getService(MessagingServices.JBOSS_MESSAGING);
        if (controller != null) {
            return (HornetQServer)HornetQServer.class.cast(controller.getValue());
        }
        return null;
    }
}

