/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.Locale;
import org.hornetq.api.jms.management.ConnectionFactoryControl;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.management.ManagementService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.jms.AbstractAddJndiHandler;
import org.jboss.dmr.ModelNode;

public class ConnectionFactoryAddJndiHandler
extends AbstractAddJndiHandler {
    public static final ConnectionFactoryAddJndiHandler INSTANCE = new ConnectionFactoryAddJndiHandler();

    private ConnectionFactoryAddJndiHandler() {
    }

    @Override
    protected void addJndiNameToControl(String toAdd, String resourceName, HornetQServer server, OperationContext context) {
        ManagementService mgmt = server.getManagementService();
        ConnectionFactoryControl control = (ConnectionFactoryControl)ConnectionFactoryControl.class.cast(mgmt.getResource("jms.connectionfactory." + resourceName));
        try {
            control.addJNDI(toAdd);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            context.getFailureDescription().set(e.toString());
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getAddJndiOperation(locale, "connection-factory");
    }
}

