/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.Arrays;
import java.util.List;
import org.hornetq.api.jms.management.ConnectionFactoryControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class ConnectionFactoryReadAttributeHandler
extends AbstractRuntimeOnlyHandler {
    public static final ConnectionFactoryReadAttributeHandler INSTANCE = new ConnectionFactoryReadAttributeHandler();
    public static final List<String> READ_ATTRIBUTES = Arrays.asList(CommonAttributes.HA.getName(), "factory-type", "initial-message-packet-size");
    private ParametersValidator validator = new ParametersValidator();

    private ConnectionFactoryReadAttributeHandler() {
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
    }

    public void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        String attributeName = operation.require("name").asString();
        String factoryName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        ServiceController hqService = context.getServiceRegistry(false).getService(MessagingServices.JBOSS_MESSAGING);
        HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
        ConnectionFactoryControl control = (ConnectionFactoryControl)ConnectionFactoryControl.class.cast(hqServer.getManagementService().getResource("jms.connectionfactory." + factoryName));
        if (CommonAttributes.HA.getName().equals(attributeName)) {
            context.getResult().set(control.isHA());
        } else if ("factory-type".equals(attributeName)) {
            context.getResult().set(control.getFactoryType());
        } else if ("initial-message-packet-size".equals(attributeName)) {
            context.getResult().set(control.getInitialMessagePacketSize());
        } else if (READ_ATTRIBUTES.contains(attributeName)) {
            throw new IllegalStateException(String.format("Read support for attribute %s was not properly implemented", attributeName));
        }
        context.completeStep();
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        for (String attr : READ_ATTRIBUTES) {
            registration.registerReadOnlyAttribute(attr, (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
    }
}

