/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.messaging.Attribute;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.Element;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JndiEntriesAttribute
extends ListAttributeDefinition {
    public static final JndiEntriesAttribute DESTINATION = new JndiEntriesAttribute(true);
    public static final JndiEntriesAttribute CONNECTION_FACTORY = new JndiEntriesAttribute(false);
    private static final String[] NO_BINDINGS = new String[0];
    private final boolean forDestination;

    private JndiEntriesAttribute(boolean forDestination) {
        super("entries", "entries", false, 1, Integer.MAX_VALUE, (ParameterValidator)new StringLengthValidator(1));
        this.forDestination = forDestination;
    }

    public void marshallAsElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
        List list;
        if (resourceModel.hasDefined(this.getName()) && (list = resourceModel.get(this.getName()).asList()).size() > 0) {
            if (!this.forDestination) {
                writer.writeStartElement(this.getXmlName());
            }
            for (ModelNode child : list) {
                writer.writeEmptyElement(Element.ENTRY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), child.asString());
            }
            if (!this.forDestination) {
                writer.writeEndElement();
            }
        }
    }

    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle) {
        node.get("value-type").set(ModelType.STRING);
    }

    static String[] getJndiBindings(ModelNode node) {
        if (node.hasDefined(CommonAttributes.ENTRIES.getName())) {
            HashSet<String> bindings = new HashSet<String>();
            for (ModelNode entry : node.get(CommonAttributes.ENTRIES.getName()).asList()) {
                bindings.add(entry.asString());
            }
            return bindings.toArray(new String[bindings.size()]);
        }
        return NO_BINDINGS;
    }
}

