/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.util.jar.Manifest;
import org.jboss.as.osgi.deployment.BundleInfoAttachment;
import org.jboss.as.osgi.deployment.DeploymentHolderService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleException;

public class OSGiBundleInfoParseProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        String contextName = deploymentUnit.getName();
        ServiceRegistry serviceRegistry = phaseContext.getServiceRegistry();
        BundleInfo info = BundleInfoAttachment.getBundleInfo(deploymentUnit);
        ServiceController<Deployment> deploymentController = DeploymentHolderService.getDeployment(serviceRegistry, contextName);
        if (info != null || deploymentController != null) {
            return;
        }
        org.jboss.vfs.VirtualFile virtualFile = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        Manifest manifest = (Manifest)deploymentUnit.getAttachment(Attachments.OSGI_MANIFEST);
        if (manifest == null) {
            return;
        }
        try {
            info = BundleInfo.createBundleInfo((VirtualFile)AbstractVFS.adapt((Object)virtualFile), (String)contextName);
            BundleInfoAttachment.attachBundleInfo(deploymentUnit, info);
        }
        catch (BundleException ex) {
            throw new DeploymentUnitProcessingException("Cannot create bundle deployment from: " + virtualFile);
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        BundleInfoAttachment.detachBundleInfo(deploymentUnit);
    }
}

