/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.osgi.parser.Attribute;
import org.jboss.as.osgi.parser.Element;
import org.jboss.as.osgi.parser.Namespace;
import org.jboss.as.osgi.parser.OSGiSubsystemAdd;
import org.jboss.as.osgi.parser.OSGiSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class OSGiExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "osgi";
    private static final OSGiSubsystemParser PARSER = new OSGiSubsystemParser();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ModelNodeRegistration registration = subsystem.registerSubsystemModel(OSGiSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationHandler)OSGiSubsystemAdd.INSTANCE, OSGiSubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationHandler)OSGiSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)OSGiSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerXMLElementWriter((XMLElementWriter)PARSER);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)PARSER);
    }

    private static class OSGiSubsystemDescribeHandler
    implements ModelQueryOperationHandler,
    DescriptionProvider {
        static final OSGiSubsystemDescribeHandler INSTANCE = new OSGiSubsystemDescribeHandler();

        private OSGiSubsystemDescribeHandler() {
        }

        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
            ModelNode model = context.getSubModel();
            PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
            ModelNode result = new ModelNode();
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").set(rootAddress.toModelNode());
            if (model.has("activation")) {
                subsystem.get("activation").set(model.get("activation"));
            }
            if (model.has("configuration")) {
                subsystem.get("configuration").set(model.get("configuration"));
            }
            if (model.has("properties")) {
                subsystem.get("properties").set(model.get("properties"));
            }
            if (model.has("modules")) {
                subsystem.get("modules").set(model.get("modules"));
            }
            result.add(subsystem);
            resultHandler.handleResultFragment(Util.NO_LOCATION, result);
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    static class OSGiSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        OSGiSubsystemParser() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
            ModelNode addSubsystemOp = new ModelNode();
            addSubsystemOp.get("operation").set("add");
            addSubsystemOp.get("address").add("subsystem", OSGiExtension.SUBSYSTEM_NAME);
            this.parseActivationAttribute(reader, addSubsystemOp);
            block8: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case OSGI_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        switch (element) {
                            case CONFIGURATION: {
                                ModelNode configuration = this.parseConfigurationElement(reader);
                                addSubsystemOp.get("configuration").set(configuration);
                                continue block8;
                            }
                            case PROPERTIES: {
                                ModelNode properties = this.parsePropertiesElement(reader);
                                if (properties == null) continue block8;
                                addSubsystemOp.get("properties").set(properties);
                                continue block8;
                            }
                            case MODULES: {
                                ModelNode modules = this.parseModulesElement(reader);
                                if (modules == null) continue block8;
                                addSubsystemOp.get("modules").set(modules);
                                continue block8;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            operations.add(addSubsystemOp);
        }

        private void parseActivationAttribute(XMLExtendedStreamReader reader, ModelNode addOperation) throws XMLStreamException {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case OSGI_1_0: {
                    int count = reader.getAttributeCount();
                    block6: for (int i = 0; i < count; ++i) {
                        ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                        String attrValue = reader.getAttributeValue(i);
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case ACTIVATION: {
                                addOperation.get("activation").set(attrValue);
                                continue block6;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }

        ModelNode parseConfigurationElement(XMLExtendedStreamReader reader) throws XMLStreamException {
            ModelNode configuration = new ModelNode();
            String pid = null;
            int count = reader.getAttributeCount();
            block9: for (int i = 0; i < count; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case PID: {
                        pid = attrValue;
                        continue block9;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (pid == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PID));
            }
            configuration.get("pid").set(pid);
            ModelNode configurationProperties = new ModelNode();
            block10: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case OSGI_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (element == Element.PROPERTY) {
                            String name = null;
                            count = reader.getAttributeCount();
                            block11: for (int i = 0; i < count; ++i) {
                                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                                String attrValue = reader.getAttributeValue(i);
                                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                                switch (attribute) {
                                    case NAME: {
                                        name = attrValue;
                                        if (!configurationProperties.has(name)) continue block11;
                                        throw new XMLStreamException("Property " + name + " already exists", reader.getLocation());
                                    }
                                    default: {
                                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                    }
                                }
                            }
                            if (name == null) {
                                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
                            }
                            String value = reader.getElementText().trim();
                            if (value == null || value.length() == 0) {
                                throw new XMLStreamException("Value for property " + name + " is null", reader.getLocation());
                            }
                            configurationProperties.get(name).set(value);
                            continue block10;
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (configurationProperties.asList().size() > 0) {
                configuration.get("configuration_properties").set(configurationProperties);
            }
            return configuration;
        }

        ModelNode parsePropertiesElement(XMLExtendedStreamReader reader) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            ModelNode properties = null;
            block6: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case OSGI_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (element == Element.PROPERTY) {
                            if (properties == null) {
                                properties = new ModelNode();
                            }
                            String name = null;
                            String value = null;
                            int count = reader.getAttributeCount();
                            block7: for (int i = 0; i < count; ++i) {
                                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                                String attrValue = reader.getAttributeValue(i);
                                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                                switch (attribute) {
                                    case NAME: {
                                        name = attrValue;
                                        if (!properties.has(name)) continue block7;
                                        throw new XMLStreamException("Property " + name + " already exists", reader.getLocation());
                                    }
                                    default: {
                                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                    }
                                }
                            }
                            if (name == null) {
                                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
                            }
                            value = reader.getElementText().trim();
                            properties.get(name).set(value);
                            continue block6;
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            return properties;
        }

        ModelNode parseModulesElement(XMLExtendedStreamReader reader) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            ModelNode modules = null;
            block7: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case OSGI_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (element == Element.MODULE) {
                            if (modules == null) {
                                modules = new ModelNode();
                            }
                            String identifier = null;
                            String start = null;
                            int count = reader.getAttributeCount();
                            block8: for (int i = 0; i < count; ++i) {
                                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                                switch (attribute) {
                                    case IDENTIFIER: {
                                        identifier = reader.getAttributeValue(i);
                                        continue block8;
                                    }
                                    case START: {
                                        start = reader.getAttributeValue(i);
                                        continue block8;
                                    }
                                    default: {
                                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                    }
                                }
                            }
                            if (identifier == null) {
                                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.IDENTIFIER));
                            }
                            if (modules.has(identifier)) {
                                throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                            }
                            ModelNode module = new ModelNode();
                            if (start != null) {
                                module.get("start").set(start);
                            }
                            modules.get(identifier).set(module);
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                            continue block7;
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            return modules;
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            Set keys;
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            ModelNode node = context.getModelNode();
            if (this.has(node, "activation")) {
                this.writeAttribute(writer, Attribute.ACTIVATION, node.get("activation"));
            }
            if (this.has(node, "configuration")) {
                ModelNode configuration = node.get("configuration");
                writer.writeStartElement(Element.CONFIGURATION.getLocalName());
                this.writeAttribute(writer, Attribute.PID, configuration.require("pid"));
                if (this.has(configuration, "configuration_properties")) {
                    ModelNode configurationProperties = configuration.get("configuration_properties");
                    Set keys2 = configurationProperties.keys();
                    for (String current : keys2) {
                        String value = configurationProperties.get(current).asString();
                        writer.writeStartElement(Element.PROPERTY.getLocalName());
                        writer.writeAttribute(Attribute.NAME.getLocalName(), current);
                        writer.writeCharacters(value);
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
            if (this.has(node, "properties")) {
                ModelNode properties = node.get("properties");
                writer.writeStartElement(Element.PROPERTIES.getLocalName());
                keys = properties.keys();
                for (String current : keys) {
                    String value = properties.get(current).asString();
                    writer.writeStartElement(Element.PROPERTY.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), current);
                    writer.writeCharacters(value);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (this.has(node, "modules")) {
                ModelNode modules = node.get("modules");
                writer.writeStartElement(Element.MODULES.getLocalName());
                keys = modules.keys();
                for (String current : keys) {
                    ModelNode currentModule = modules.get(current);
                    writer.writeEmptyElement(Element.MODULE.getLocalName());
                    writer.writeAttribute(Attribute.IDENTIFIER.getLocalName(), current);
                    if (!this.has(currentModule, "start")) continue;
                    this.writeAttribute(writer, Attribute.START, currentModule.require("start"));
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }

        private boolean has(ModelNode node, String name) {
            return node.has(name) && node.get(name).isDefined();
        }

        private void writeAttribute(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
            writer.writeAttribute(attr.getLocalName(), value.asString());
        }
    }
}

