/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.util.List;
import org.jboss.as.server.Services;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.logging.Logger;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.ModuleLoaderProvider;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XModuleIdentity;
import org.jboss.osgi.spi.NotImplementedException;

final class ModuleLoaderIntegration
extends ModuleLoader
implements ModuleLoaderProvider {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    private final InjectedValue<ServiceModuleLoader> injectedModuleLoader = new InjectedValue();
    private ServiceContainer serviceContainer;
    private ServiceTarget serviceTarget;

    static void addService(ServiceTarget target) {
        ModuleLoaderIntegration service = new ModuleLoaderIntegration();
        ServiceBuilder builder = target.addService(org.jboss.osgi.framework.Services.MODULE_LOADER_PROVIDER, (Service)service);
        builder.addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ServiceModuleLoader.class, service.injectedModuleLoader);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private ModuleLoaderIntegration() {
    }

    public void start(StartContext context) throws StartException {
        log.debugf("Starting: %s", (Object)context.getController().getName());
        this.serviceContainer = context.getController().getServiceContainer();
        this.serviceTarget = context.getChildTarget();
    }

    public void stop(StopContext context) {
        log.debugf("Stopping: %s", (Object)context.getController().getName());
    }

    public ModuleLoaderProvider getValue() throws IllegalStateException {
        return this;
    }

    public ModuleLoader getModuleLoader() {
        return this;
    }

    public void addModule(final ModuleSpec moduleSpec) {
        ModuleIdentifier identifier = moduleSpec.getModuleIdentifier();
        ServiceName serviceName = ServiceModuleLoader.moduleSpecServiceName((ModuleIdentifier)identifier);
        ServiceBuilder builder = this.serviceTarget.addService(serviceName, (Service)new AbstractService<ModuleSpec>(){

            public ModuleSpec getValue() throws IllegalStateException {
                return moduleSpec;
            }
        });
        builder.install();
    }

    public void addModule(final Module module) {
        ServiceName serviceName = this.getModuleServiceName(module.getIdentifier());
        if (this.serviceContainer.getService(serviceName) == null) {
            ServiceBuilder builder = this.serviceTarget.addService(serviceName, (Service)new AbstractService<Module>(){

                public Module getValue() throws IllegalStateException {
                    return module;
                }
            });
            builder.install();
        }
    }

    public void removeModule(ModuleIdentifier identifier) {
        ServiceName serviceName = this.getModuleSpecServiceName(identifier);
        ServiceController controller = this.serviceContainer.getService(serviceName);
        if (controller != null) {
            controller.setMode(ServiceController.Mode.REMOVE);
        }
        if ((controller = this.serviceContainer.getService(serviceName = this.getModuleServiceName(identifier))) != null) {
            controller.setMode(ServiceController.Mode.REMOVE);
        }
    }

    public ModuleIdentifier getModuleIdentifier(XModule resModule) {
        if (resModule == null) {
            throw new IllegalArgumentException("Null resModule");
        }
        XModuleIdentity moduleId = resModule.getModuleId();
        String slot = moduleId.getVersion().toString();
        int revision = moduleId.getRevision();
        if (revision > 0) {
            slot = slot + "-rev" + revision;
        }
        String name = "deployment." + moduleId.getName();
        ModuleIdentifier identifier = ModuleIdentifier.create((String)name, (String)slot);
        resModule.addAttachment(ModuleIdentifier.class, (Object)identifier);
        return identifier;
    }

    protected ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
        ServiceName serviceName = ServiceModuleLoader.moduleSpecServiceName((ModuleIdentifier)identifier);
        ServiceController controller = this.serviceContainer.getService(serviceName);
        return controller != null ? (ModuleSpec)controller.getValue() : null;
    }

    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        ServiceName serviceName = this.getModuleServiceName(identifier);
        ServiceController controller = this.serviceContainer.getService(serviceName);
        return controller != null ? (Module)controller.getValue() : ModuleLoader.preloadModule((ModuleIdentifier)identifier, (ModuleLoader)((ModuleLoader)this.injectedModuleLoader.getValue()));
    }

    public void setAndRelinkDependencies(Module module, List<DependencySpec> dependencies) throws ModuleLoadException {
        throw new NotImplementedException();
    }

    private ServiceName getModuleSpecServiceName(ModuleIdentifier identifier) {
        return ServiceModuleLoader.MODULE_SPEC_SERVICE_PREFIX.append(new String[]{identifier.getName()}).append(new String[]{identifier.getSlot()});
    }

    private ServiceName getModuleServiceName(ModuleIdentifier identifier) {
        return ServiceModuleLoader.MODULE_SERVICE_PREFIX.append(new String[]{identifier.getName()}).append(new String[]{identifier.getSlot()});
    }

    public String toString() {
        return ModuleLoaderIntegration.class.getSimpleName();
    }
}

