/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.platform.mbean.SecurityActions;
import org.jboss.dmr.ModelNode;

public class PlatformMBeanUtil {
    public static final int JVM_MAJOR_VERSION;

    public static String escapeMBeanName(String toEscape) {
        return toEscape.replace(' ', '_');
    }

    public static String unescapeMBeanValue(String toUnescape) {
        String unescaped = toUnescape.replace('_', ' ');
        return unescaped.equals(toUnescape) ? toUnescape : "\"" + unescaped + "\"";
    }

    public static String getObjectNameStringWithNameKey(String base, String escapedValue) {
        String value = PlatformMBeanUtil.unescapeMBeanValue(escapedValue);
        return base + ",name=" + value;
    }

    public static ObjectName getObjectNameWithNameKey(String base, String escapedValue) throws OperationFailedException {
        try {
            return new ObjectName(PlatformMBeanUtil.getObjectNameStringWithNameKey(base, escapedValue));
        }
        catch (MalformedObjectNameException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
    }

    public static Object getMBeanAttribute(ObjectName objectName, String attribute) throws OperationFailedException {
        try {
            return ManagementFactory.getPlatformMBeanServer().getAttribute(objectName, attribute);
        }
        catch (ReflectionException e) {
            Exception t = e.getTargetException();
            if (t instanceof SecurityException || t instanceof UnsupportedOperationException) {
                throw new OperationFailedException(new ModelNode().set(t.toString()));
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    public static ModelNode getDetypedMemoryUsage(MemoryUsage memoryUsage) {
        ModelNode result = new ModelNode();
        if (memoryUsage != null) {
            result.get("init").set(memoryUsage.getInit());
            result.get("used").set(memoryUsage.getUsed());
            result.get("committed").set(memoryUsage.getCommitted());
            result.get("max").set(memoryUsage.getMax());
        }
        return result;
    }

    public static ModelNode getDetypedThreadInfo(ThreadInfo threadInfo, boolean includeBlockedTime) {
        ModelNode result = new ModelNode();
        result.get("thread-id").set(threadInfo.getThreadId());
        result.get("thread-name").set(threadInfo.getThreadName());
        result.get("thread-state").set(threadInfo.getThreadState().name());
        if (includeBlockedTime) {
            result.get("blocked-time").set(threadInfo.getBlockedTime());
        } else {
            result.get("blocked-time");
        }
        result.get("blocked-count").set(threadInfo.getBlockedCount());
        result.get("waited-time").set(threadInfo.getWaitedTime());
        result.get("waited-count").set(threadInfo.getWaitedCount());
        result.get("lock-info").set(PlatformMBeanUtil.getDetypedLockInfo(threadInfo.getLockInfo()));
        PlatformMBeanUtil.nullSafeSet(result.get("lock-name"), threadInfo.getLockName());
        result.get("lock-owner-id").set(threadInfo.getLockOwnerId());
        PlatformMBeanUtil.nullSafeSet(result.get("lock-owner-name"), threadInfo.getLockOwnerName());
        ModelNode stack = result.get("stack-trace");
        stack.setEmptyList();
        for (StackTraceElement ste : threadInfo.getStackTrace()) {
            stack.add(PlatformMBeanUtil.getDetypedStackTraceElement(ste));
        }
        result.get("suspended").set(threadInfo.isSuspended());
        result.get("in-native").set(threadInfo.isInNative());
        ModelNode monitors = result.get("locked-monitors");
        monitors.setEmptyList();
        for (MonitorInfo monitor : threadInfo.getLockedMonitors()) {
            monitors.add(PlatformMBeanUtil.getDetypedMonitorInfo(monitor));
        }
        ModelNode synchronizers = result.get("locked-synchronizers");
        synchronizers.setEmptyList();
        for (LockInfo lock : threadInfo.getLockedSynchronizers()) {
            synchronizers.add(PlatformMBeanUtil.getDetypedLockInfo(lock));
        }
        return result;
    }

    private static void nullSafeSet(ModelNode node, String value) {
        if (value != null) {
            node.set(value);
        }
    }

    private static ModelNode getDetypedLockInfo(LockInfo lockInfo) {
        ModelNode result = new ModelNode();
        if (lockInfo != null) {
            result.get("class-name").set(lockInfo.getClassName());
            result.get("identity-hash-code").set(lockInfo.getIdentityHashCode());
        }
        return result;
    }

    private static ModelNode getDetypedMonitorInfo(MonitorInfo monitorInfo) {
        ModelNode result = PlatformMBeanUtil.getDetypedLockInfo(monitorInfo);
        if (monitorInfo != null) {
            result.get("locked-stack-depth").set(monitorInfo.getLockedStackDepth());
            ModelNode frame = PlatformMBeanUtil.getDetypedStackTraceElement(monitorInfo.getLockedStackFrame());
            result.get("locked-stack-frame").set(frame);
        }
        return result;
    }

    private static ModelNode getDetypedStackTraceElement(StackTraceElement stackTraceElement) {
        ModelNode result = new ModelNode();
        if (stackTraceElement != null) {
            PlatformMBeanUtil.nullSafeSet(result.get("file-name"), stackTraceElement.getFileName());
            result.get("line-number").set(stackTraceElement.getLineNumber());
            result.get("class-name").set(stackTraceElement.getClassName());
            result.get("method-name").set(stackTraceElement.getMethodName());
            result.get("native-method").set(stackTraceElement.isNativeMethod());
        }
        return result;
    }

    private PlatformMBeanUtil() {
    }

    static {
        int vmVersion;
        try {
            String vmVersionStr = SecurityActions.getSystemProperty("java.specification.version");
            vmVersion = Integer.valueOf(vmVersionStr.substring(2));
        }
        catch (Exception e) {
            vmVersion = 6;
        }
        JVM_MAJOR_VERSION = vmVersion;
    }
}

