/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.remoting.RealmAuthenticationProvider;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.sasl.JBossSaslProvider;

class RealmAuthenticationProviderService
implements Service<RealmAuthenticationProvider> {
    private final InjectedValue<SecurityRealm> securityRealmInjectedValue = new InjectedValue();
    private final InjectedValue<CallbackHandler> serverCallbackValue = new InjectedValue();
    private volatile RealmAuthenticationProvider realmAuthenticationProvider = null;

    RealmAuthenticationProviderService() {
    }

    public void start(StartContext startContext) throws StartException {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                JBossSaslProvider saslProvider = new JBossSaslProvider();
                if (Security.getProvider(saslProvider.getName()) == null) {
                    Security.insertProviderAt((Provider)saslProvider, 1);
                }
                return null;
            }
        });
        this.realmAuthenticationProvider = new RealmAuthenticationProvider((SecurityRealm)this.securityRealmInjectedValue.getOptionalValue(), (CallbackHandler)this.serverCallbackValue.getOptionalValue());
    }

    public void stop(StopContext stopContext) {
        this.realmAuthenticationProvider = null;
    }

    public RealmAuthenticationProvider getValue() throws IllegalStateException, IllegalArgumentException {
        return this.realmAuthenticationProvider;
    }

    public InjectedValue<SecurityRealm> getSecurityRealmInjectedValue() {
        return this.securityRealmInjectedValue;
    }

    public InjectedValue<CallbackHandler> getServerCallbackValue() {
        return this.serverCallbackValue;
    }
}

