/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.io.IOException;
import java.util.ArrayList;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.DomainCallbackHandler;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.sasl.callback.VerifyPasswordCallback;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Sequence;

class RealmAuthenticationProvider
implements ServerAuthenticationProvider {
    static final String ANONYMOUS = "ANONYMOUS";
    static final String DIGEST_MD5 = "DIGEST-MD5";
    static final String PLAIN = "PLAIN";
    private final SecurityRealm realm;
    private final CallbackHandler serverCallbackHandler;

    RealmAuthenticationProvider(SecurityRealm realm, CallbackHandler serverCallbackHandler) {
        this.realm = realm;
        this.serverCallbackHandler = serverCallbackHandler;
    }

    OptionMap getSaslOptionMap() {
        if (this.digestMd5Supported()) {
            return OptionMap.create((Option)Options.SASL_MECHANISMS, (Object)Sequence.of((Object[])new String[]{DIGEST_MD5}));
        }
        if (this.plainSupported()) {
            throw new IllegalStateException("PLAIN not enabled until SSL supported for Native Interface");
        }
        if (this.realm == null) {
            return OptionMap.create((Option)Options.SASL_MECHANISMS, (Object)Sequence.of((Object[])new String[]{ANONYMOUS}), (Option)Options.SASL_POLICY_NOANONYMOUS, (Object)Boolean.FALSE);
        }
        throw new IllegalStateException("A security realm has been specified but no supported mechanism identified.");
    }

    public CallbackHandler getCallbackHandler(String mechanismName) {
        if (ANONYMOUS.equals(mechanismName) && this.realm == null) {
            return new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    int i$ = 0;
                    Callback[] arr$ = callbacks;
                    int len$ = arr$.length;
                    if (i$ < len$) {
                        Callback current = arr$[i$];
                        throw new UnsupportedCallbackException(current, "ANONYMOUS mechanism so not expecting a callback");
                    }
                }
            };
        }
        Object realmCallbackHandler = null;
        if (DIGEST_MD5.equals(mechanismName) && this.digestMd5Supported()) {
            DomainCallbackHandler realHandler = this.realm.getCallbackHandler();
            CallbackHandler realmNameFix = new CallbackHandler((CallbackHandler)realHandler){
                final /* synthetic */ CallbackHandler val$realHandler;
                {
                    this.val$realHandler = callbackHandler;
                }

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    ArrayList<Callback> filteredCallbacks = new ArrayList<Callback>(callbacks.length - 1);
                    for (Callback current : callbacks) {
                        if (current instanceof RealmCallback) continue;
                        filteredCallbacks.add(current);
                    }
                    this.val$realHandler.handle(filteredCallbacks.toArray(new Callback[filteredCallbacks.size()]));
                }
            };
            realmCallbackHandler = realmNameFix;
        } else if (PLAIN.equals(mechanismName) && this.plainSupported()) {
            realmCallbackHandler = this.realm.getCallbackHandler();
        } else {
            throw new IllegalStateException("Unsupported Callback '" + mechanismName + "'");
        }
        if (this.serverCallbackHandler == null) {
            return realmCallbackHandler;
        }
        Object wrappedHandler = realmCallbackHandler;
        return new CallbackHandler((CallbackHandler)wrappedHandler){
            final /* synthetic */ CallbackHandler val$wrappedHandler;
            {
                this.val$wrappedHandler = callbackHandler;
            }

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                RealmAuthenticationProvider.this.serverCallbackHandler.handle(callbacks);
                if (!this.handled(callbacks)) {
                    this.val$wrappedHandler.handle(callbacks);
                }
            }

            private boolean handled(Callback[] callbacks) {
                for (Callback current : callbacks) {
                    if (current instanceof PasswordCallback) {
                        PasswordCallback pcb = (PasswordCallback)current;
                        char[] password = pcb.getPassword();
                        return password != null && password.length > 0;
                    }
                    if (!(current instanceof VerifyPasswordCallback)) continue;
                    return ((VerifyPasswordCallback)current).isVerified();
                }
                return false;
            }
        };
    }

    private boolean digestMd5Supported() {
        if (this.realm == null) {
            return false;
        }
        Class[] callbacks = this.realm.getCallbackHandler().getSupportedCallbacks();
        if (!RealmAuthenticationProvider.contains(NameCallback.class, callbacks)) {
            return false;
        }
        if (!RealmAuthenticationProvider.contains(RealmCallback.class, callbacks)) {
            return false;
        }
        if (!RealmAuthenticationProvider.contains(PasswordCallback.class, callbacks)) {
            return false;
        }
        return RealmAuthenticationProvider.contains(AuthorizeCallback.class, callbacks);
    }

    private boolean plainSupported() {
        if (this.realm == null) {
            return false;
        }
        Class[] callbacks = this.realm.getCallbackHandler().getSupportedCallbacks();
        if (!RealmAuthenticationProvider.contains(NameCallback.class, callbacks)) {
            return false;
        }
        if (!RealmAuthenticationProvider.contains(VerifyPasswordCallback.class, callbacks)) {
            return false;
        }
        return RealmAuthenticationProvider.contains(AuthorizeCallback.class, callbacks);
    }

    private static boolean contains(Class clazz, Class[] classes) {
        for (Class current : classes) {
            if (!current.equals(clazz)) continue;
            return true;
        }
        return false;
    }
}

