/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;

public abstract class ServerWriteAttributeOperationHandler
extends WriteAttributeHandlers.WriteAttributeOperationHandler {
    private final ParameterValidator resolvedValueValidator;

    public ServerWriteAttributeOperationHandler() {
        this(null, null);
    }

    public ServerWriteAttributeOperationHandler(ParameterValidator valueValidator) {
        this(valueValidator, null);
    }

    public ServerWriteAttributeOperationHandler(ParameterValidator valueValidator, ParameterValidator resolvedValueValidator) {
        super(valueValidator);
        this.resolvedValueValidator = resolvedValueValidator;
    }

    protected void modelChanged(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
        boolean restartRequired = false;
        if (context.getType() == OperationContext.Type.SERVER) {
            this.validateResolvedValue(attributeName, newValue);
            ModelNode resolvedValue = newValue.isDefined() ? newValue.resolve() : newValue;
            restartRequired = this.applyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue);
            if (restartRequired) {
                context.reloadRequired();
            }
        }
        if (context.completeStep() != OperationContext.ResultAction.KEEP && restartRequired) {
            context.revertReloadRequired();
        }
    }

    protected void validateResolvedValue(String name, ModelNode value) throws OperationFailedException {
        if (this.resolvedValueValidator != null) {
            this.resolvedValueValidator.validateParameter(name, value.resolve());
        }
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
        return false;
    }
}

