/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.annotation;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.moduleservice.ModuleIndexBuilder;
import org.jboss.jandex.Index;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

public class CompositeIndexProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger(CompositeIndexProcessor.class);

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ResourceRoot deploymentRoot;
        List resourceRoots;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Boolean computeCompositeIndex = deploymentUnit.getAttachment(Attachments.COMPUTE_COMPOSITE_ANNOTATION_INDEX);
        if (computeCompositeIndex != null && !computeCompositeIndex.booleanValue()) {
            return;
        }
        List<ModuleIdentifier> additionalModuleIndexes = deploymentUnit.getAttachmentList(Attachments.ADDITIONAL_ANNOTATION_INDEXES);
        ArrayList<Index> indexes = new ArrayList<Index>();
        for (ModuleIdentifier moduleIdentifier : additionalModuleIndexes) {
            try {
                Module module = Module.getBootModuleLoader().loadModule(moduleIdentifier);
                CompositeIndex additionalIndex = ModuleIndexBuilder.buildCompositeIndex(module);
                if (additionalIndex != null) {
                    indexes.addAll(additionalIndex.indexes);
                    continue;
                }
                log.errorf("Module %s will not have it's annotations processed as no %s file was found in the deployment. Please generate this file using the Jandex ant task.", (Object)module.getIdentifier(), (Object)"META-INF/jandex.idx");
            }
            catch (ModuleLoadException e) {
                throw new DeploymentUnitProcessingException(e);
            }
        }
        ArrayList<ResourceRoot> allResourceRoots = new ArrayList<ResourceRoot>();
        Boolean processChildren = deploymentUnit.getAttachment(Attachments.PROCESS_CHILD_ANNOTATION_INDEX);
        if ((processChildren == null || processChildren.booleanValue()) && (resourceRoots = (List)deploymentUnit.getAttachment(Attachments.RESOURCE_ROOTS)) != null) {
            for (ResourceRoot resourceRoot : resourceRoots) {
                if (SubDeploymentMarker.isSubDeployment(resourceRoot) || !ModuleRootMarker.isModuleRoot(resourceRoot)) continue;
                allResourceRoots.add(resourceRoot);
            }
        }
        if (ModuleRootMarker.isModuleRoot(deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT))) {
            allResourceRoots.add(deploymentRoot);
        }
        for (ResourceRoot resourceRoot : allResourceRoots) {
            Index index = resourceRoot.getAttachment(Attachments.ANNOTATION_INDEX);
            if (index == null) continue;
            indexes.add(index);
        }
        deploymentUnit.putAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX, new CompositeIndex(indexes));
    }

    @Override
    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
    }
}

