/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public abstract class ServerWriteAttributeOperationHandler
extends WriteAttributeHandlers.WriteAttributeOperationHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server");
    private final ParameterValidator resolvedValueValidator;

    public ServerWriteAttributeOperationHandler() {
        this(null, null);
    }

    public ServerWriteAttributeOperationHandler(ParameterValidator valueValidator) {
        this(valueValidator, null);
    }

    public ServerWriteAttributeOperationHandler(ParameterValidator valueValidator, ParameterValidator resolvedValueValidator) {
        super(valueValidator);
        this.resolvedValueValidator = resolvedValueValidator;
    }

    protected void modelChanged(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
        boolean restartRequired = false;
        boolean applyToRuntime = context.getType() == OperationContext.Type.SERVER;
        ModelNode resolvedValue = null;
        if (applyToRuntime) {
            this.validateResolvedValue(attributeName, newValue);
            resolvedValue = newValue.resolve();
            restartRequired = this.applyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue);
            if (restartRequired) {
                context.reloadRequired();
            }
        }
        if (context.completeStep() != OperationContext.ResultAction.KEEP && applyToRuntime) {
            ModelNode valueToRestore = currentValue.resolve();
            try {
                this.revertUpdateToRuntime(context, operation, attributeName, valueToRestore, resolvedValue);
            }
            catch (Exception e) {
                log.errorf((Throwable)e, String.format("%s caught exception attempting to revert operation %s at address %s", ((Object)((Object)this)).getClass().getSimpleName(), operation.require("operation").asString(), PathAddress.pathAddress((ModelNode)operation.require("address"))), new Object[0]);
            }
            if (restartRequired) {
                context.revertReloadRequired();
            }
        }
    }

    protected void validateResolvedValue(String name, ModelNode value) throws OperationFailedException {
        if (this.resolvedValueValidator != null) {
            this.resolvedValueValidator.validateParameter(name, value.resolve());
        }
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
        return true;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert) throws OperationFailedException {
    }
}

