/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.annotation;

import java.io.Closeable;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.Indexer;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;

public class ResourceRootIndexer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void indexResourceRoot(ResourceRoot resourceRoot) throws DeploymentUnitProcessingException {
        Boolean shouldIndexResource;
        if (resourceRoot.getAttachment(Attachments.ANNOTATION_INDEX) != null) {
            return;
        }
        VirtualFile indexFile = resourceRoot.getRoot().getChild("META-INF/jandex.idx");
        if (indexFile.exists()) {
            try {
                IndexReader reader = new IndexReader(indexFile.openStream());
                resourceRoot.putAttachment(Attachments.ANNOTATION_INDEX, reader.read());
                ServerLogger.DEPLOYMENT_LOGGER.tracef("Found and read index at: %s", indexFile);
                return;
            }
            catch (Exception e) {
                ServerLogger.DEPLOYMENT_LOGGER.cannotLoadAnnotationIndex(indexFile.getPathName());
            }
        }
        if ((shouldIndexResource = resourceRoot.getAttachment(Attachments.INDEX_RESOURCE_ROOT)) != null && !shouldIndexResource.booleanValue()) {
            return;
        }
        List indexIgnorePathList = resourceRoot.getAttachment(Attachments.INDEX_IGNORE_PATHS);
        final HashSet indexIgnorePaths = indexIgnorePathList != null && !indexIgnorePathList.isEmpty() ? new HashSet(indexIgnorePathList) : null;
        final VirtualFile virtualFile = resourceRoot.getRoot();
        Indexer indexer = new Indexer();
        try {
            VisitorAttributes visitorAttributes = new VisitorAttributes();
            visitorAttributes.setLeavesOnly(true);
            visitorAttributes.setRecurseFilter(new VirtualFileFilter(){

                public boolean accepts(VirtualFile file) {
                    return indexIgnorePaths == null || !indexIgnorePaths.contains(file.getPathNameRelativeTo(virtualFile));
                }
            });
            List classChildren = virtualFile.getChildren((VirtualFileFilter)new SuffixMatchFilter(".class", visitorAttributes));
            for (VirtualFile classFile : classChildren) {
                InputStream inputStream = null;
                try {
                    inputStream = classFile.openStream();
                    indexer.index(inputStream);
                }
                catch (Exception e) {
                    ServerLogger.DEPLOYMENT_LOGGER.cannotIndexClass(classFile.getPathNameRelativeTo(virtualFile), virtualFile.getPathName(), e);
                }
                finally {
                    VFSUtils.safeClose((Closeable)inputStream);
                }
            }
            Index index = indexer.complete();
            resourceRoot.putAttachment(Attachments.ANNOTATION_INDEX, index);
            ServerLogger.DEPLOYMENT_LOGGER.tracef("Generated index for archive %s", virtualFile);
        }
        catch (Throwable t) {
            throw new DeploymentUnitProcessingException("Failed to index deployment root for annotations", t);
        }
    }
}

