/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.util.EnumSet;
import org.jboss.as.controller.CompositeOperationHandler;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonProviders;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.ExtensionResourceDefinition;
import org.jboss.as.controller.operations.common.InterfaceCriteriaWriteHandler;
import org.jboss.as.controller.operations.common.NamespaceAddHandler;
import org.jboss.as.controller.operations.common.NamespaceRemoveHandler;
import org.jboss.as.controller.operations.common.ProcessEnvironment;
import org.jboss.as.controller.operations.common.ProcessReloadHandler;
import org.jboss.as.controller.operations.common.ProcessStateAttributeHandler;
import org.jboss.as.controller.operations.common.ResolveExpressionHandler;
import org.jboss.as.controller.operations.common.SchemaLocationAddHandler;
import org.jboss.as.controller.operations.common.SchemaLocationRemoveHandler;
import org.jboss.as.controller.operations.common.SnapshotDeleteHandler;
import org.jboss.as.controller.operations.common.SnapshotListHandler;
import org.jboss.as.controller.operations.common.SnapshotTakeHandler;
import org.jboss.as.controller.operations.common.SystemPropertyAddHandler;
import org.jboss.as.controller.operations.common.SystemPropertyRemoveHandler;
import org.jboss.as.controller.operations.common.SystemPropertyValueWriteAttributeHandler;
import org.jboss.as.controller.operations.common.ValidateAddressOperationHandler;
import org.jboss.as.controller.operations.common.ValidateOperationHandler;
import org.jboss.as.controller.operations.common.XmlMarshallingHandler;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.resource.SocketBindingGroupResourceDefinition;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.as.domain.management.security.SecurityRealmResourceDefinition;
import org.jboss.as.domain.management.security.WhoAmIOperation;
import org.jboss.as.platform.mbean.PlatformMBeanResourceRegistrar;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.server.DeployerChainAddHandler;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentResourceDescription;
import org.jboss.as.server.Services;
import org.jboss.as.server.controller.descriptions.ServerDescriptionProviders;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.deployment.DeploymentAddHandler;
import org.jboss.as.server.deployment.DeploymentDeployHandler;
import org.jboss.as.server.deployment.DeploymentFullReplaceHandler;
import org.jboss.as.server.deployment.DeploymentRedeployHandler;
import org.jboss.as.server.deployment.DeploymentRemoveHandler;
import org.jboss.as.server.deployment.DeploymentReplaceHandler;
import org.jboss.as.server.deployment.DeploymentStatusHandler;
import org.jboss.as.server.deployment.DeploymentUndeployHandler;
import org.jboss.as.server.deployment.DeploymentUploadBytesHandler;
import org.jboss.as.server.deployment.DeploymentUploadStreamAttachmentHandler;
import org.jboss.as.server.deployment.DeploymentUploadURLHandler;
import org.jboss.as.server.mgmt.HttpManagementResourceDefinition;
import org.jboss.as.server.mgmt.NativeManagementResourceDefinition;
import org.jboss.as.server.mgmt.NativeRemotingManagementResourceDefinition;
import org.jboss.as.server.operations.DumpServicesHandler;
import org.jboss.as.server.operations.LaunchTypeHandler;
import org.jboss.as.server.operations.ProcessTypeHandler;
import org.jboss.as.server.operations.RootResourceHack;
import org.jboss.as.server.operations.RunningModeReadHandler;
import org.jboss.as.server.operations.ServerRestartRequiredHandler;
import org.jboss.as.server.operations.ServerShutdownHandler;
import org.jboss.as.server.services.net.BindingGroupAddHandler;
import org.jboss.as.server.services.net.BindingGroupRemoveHandler;
import org.jboss.as.server.services.net.LocalDestinationOutboundSocketBindingResourceDefinition;
import org.jboss.as.server.services.net.NetworkInterfaceRuntimeHandler;
import org.jboss.as.server.services.net.RemoteDestinationOutboundSocketBindingResourceDefinition;
import org.jboss.as.server.services.net.SocketBindingResourceDefinition;
import org.jboss.as.server.services.net.SpecifiedInterfaceAddHandler;
import org.jboss.as.server.services.net.SpecifiedInterfaceRemoveHandler;
import org.jboss.as.server.services.net.SpecifiedInterfaceResolveHandler;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.as.server.services.security.VaultAddHandler;
import org.jboss.as.server.services.security.VaultRemoveHandler;
import org.jboss.as.server.services.security.VaultWriteAttributeHandler;
import org.jboss.as.version.Version;
import org.jboss.dmr.ModelNode;

public class ServerControllerModelUtil {
    public static void updateCoreModel(ModelNode root, ServerEnvironment environment) {
        root.get("release-version").set(Version.AS_VERSION);
        root.get("release-codename").set(Version.AS_RELEASE_CODENAME);
        root.get("management-major-version").set(1);
        root.get("management-minor-version").set(2);
        ModelNode nameNode = root.get("product-name");
        ModelNode versionNode = root.get("product-version");
        if (environment != null) {
            String productName = environment.getProductConfig().getProductName();
            String productVersion = environment.getProductConfig().getProductVersion();
            if (productName != null) {
                nameNode.set(productName);
            }
            if (productVersion != null) {
                versionNode.set(productVersion);
            }
        }
        root.get("namespaces").setEmptyList();
        root.get("schema-locations").setEmptyList();
        root.get("name");
        root.get("core-service");
        root.get("profile-name");
        root.get("extension");
        root.get("system-property");
        root.get("path");
        root.get("subsystem");
        root.get("interface");
        root.get("socket-binding-group");
        root.get("deployment");
    }

    public static void initOperations(ManagementResourceRegistration root, ContentRepository contentRepository, ExtensibleConfigurationPersister extensibleConfigurationPersister, ServerEnvironment serverEnvironment, ControlledProcessState processState, RunningModeControl runningModeControl, AbstractVaultReader vaultReader, ExtensionRegistry extensionRegistry, boolean parallelBoot, DeploymentFileRepository remoteFileRepository, PathManagerService pathManager) {
        boolean isDomain;
        boolean bl = isDomain = serverEnvironment == null || serverEnvironment.getLaunchType() == ServerEnvironment.LaunchType.DOMAIN;
        if (serverEnvironment != null) {
            if (isDomain) {
                root.registerReadOnlyAttribute("name", serverEnvironment.getProcessNameReadHandler(), AttributeAccess.Storage.CONFIGURATION);
                root.registerReadWriteAttribute("profile-name", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
            } else {
                root.registerReadWriteAttribute("name", serverEnvironment.getProcessNameReadHandler(), serverEnvironment.getProcessNameWriteHandler(), AttributeAccess.Storage.CONFIGURATION);
            }
        }
        EnumSet<OperationEntry.Flag> runtimeOnlyFlag = EnumSet.of(OperationEntry.Flag.RUNTIME_ONLY);
        root.registerOperationHandler("read-resource", GlobalOperationHandlers.READ_RESOURCE, CommonProviders.READ_RESOURCE_PROVIDER, true, runtimeOnlyFlag);
        root.registerOperationHandler("read-attribute", GlobalOperationHandlers.READ_ATTRIBUTE, CommonProviders.READ_ATTRIBUTE_PROVIDER, true, runtimeOnlyFlag);
        root.registerOperationHandler("read-resource-description", GlobalOperationHandlers.READ_RESOURCE_DESCRIPTION, CommonProviders.READ_RESOURCE_DESCRIPTION_PROVIDER, true, runtimeOnlyFlag);
        root.registerOperationHandler("read-children-names", GlobalOperationHandlers.READ_CHILDREN_NAMES, CommonProviders.READ_CHILDREN_NAMES_PROVIDER, true, runtimeOnlyFlag);
        root.registerOperationHandler("read-children-types", GlobalOperationHandlers.READ_CHILDREN_TYPES, CommonProviders.READ_CHILDREN_TYPES_PROVIDER, true, runtimeOnlyFlag);
        root.registerOperationHandler("read-children-resources", GlobalOperationHandlers.READ_CHILDREN_RESOURCES, CommonProviders.READ_CHILDREN_RESOURCES_PROVIDER, true, runtimeOnlyFlag);
        root.registerOperationHandler("read-operation-names", GlobalOperationHandlers.READ_OPERATION_NAMES, CommonProviders.READ_OPERATION_NAMES_PROVIDER, true, runtimeOnlyFlag);
        root.registerOperationHandler("read-operation-description", GlobalOperationHandlers.READ_OPERATION_DESCRIPTION, CommonProviders.READ_OPERATION_PROVIDER, true, runtimeOnlyFlag);
        root.registerOperationHandler("undefine-attribute", GlobalOperationHandlers.UNDEFINE_ATTRIBUTE, CommonProviders.UNDEFINE_ATTRIBUTE_PROVIDER, true);
        root.registerOperationHandler("write-attribute", GlobalOperationHandlers.WRITE_ATTRIBUTE, CommonProviders.WRITE_ATTRIBUTE_PROVIDER, true);
        if (serverEnvironment != null) {
            root.registerOperationHandler(ValidateOperationHandler.OPERATION_NAME, (OperationStepHandler)ValidateOperationHandler.INSTANCE, (DescriptionProvider)ValidateOperationHandler.INSTANCE);
        } else {
            root.registerOperationHandler(ValidateOperationHandler.OPERATION_NAME, (OperationStepHandler)ValidateOperationHandler.INSTANCE, (DescriptionProvider)ValidateOperationHandler.INSTANCE, false, runtimeOnlyFlag);
        }
        root.registerOperationHandler("composite", (OperationStepHandler)CompositeOperationHandler.INSTANCE, (DescriptionProvider)CompositeOperationHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        XmlMarshallingHandler xmh = new XmlMarshallingHandler((ConfigurationPersister)extensibleConfigurationPersister);
        root.registerOperationHandler("read-config-as-xml", (OperationStepHandler)xmh, (DescriptionProvider)xmh, false, runtimeOnlyFlag);
        root.registerOperationHandler("add-namespace", (OperationStepHandler)NamespaceAddHandler.INSTANCE, (DescriptionProvider)NamespaceAddHandler.INSTANCE, false);
        root.registerOperationHandler("remove-namespace", (OperationStepHandler)NamespaceRemoveHandler.INSTANCE, (DescriptionProvider)NamespaceRemoveHandler.INSTANCE, false);
        root.registerOperationHandler("add-schema-location", (OperationStepHandler)SchemaLocationAddHandler.INSTANCE, (DescriptionProvider)SchemaLocationAddHandler.INSTANCE, false);
        root.registerOperationHandler("remove-schema-location", (OperationStepHandler)SchemaLocationRemoveHandler.INSTANCE, (DescriptionProvider)SchemaLocationRemoveHandler.INSTANCE, false);
        root.registerOperationHandler("validate-address", (OperationStepHandler)ValidateAddressOperationHandler.INSTANCE, (DescriptionProvider)ValidateAddressOperationHandler.INSTANCE, false, EnumSet.of(OperationEntry.Flag.READ_ONLY));
        DeploymentUploadBytesHandler dubh = new DeploymentUploadBytesHandler(contentRepository);
        root.registerOperationHandler("upload-deployment-bytes", (OperationStepHandler)dubh, (DescriptionProvider)dubh, false);
        DeploymentUploadURLHandler duuh = new DeploymentUploadURLHandler(contentRepository);
        root.registerOperationHandler("upload-deployment-url", (OperationStepHandler)duuh, (DescriptionProvider)duuh, false);
        DeploymentUploadStreamAttachmentHandler dush = new DeploymentUploadStreamAttachmentHandler(contentRepository);
        root.registerOperationHandler("upload-deployment-stream", (OperationStepHandler)dush, (DescriptionProvider)dush, false);
        DeploymentReplaceHandler drh = isDomain ? DeploymentReplaceHandler.createForDomainServer(contentRepository, remoteFileRepository, vaultReader) : DeploymentReplaceHandler.createForStandalone(contentRepository, vaultReader);
        root.registerOperationHandler("replace-deployment", (OperationStepHandler)drh, (DescriptionProvider)drh, false);
        DeploymentFullReplaceHandler dfrh = isDomain ? DeploymentFullReplaceHandler.createForDomainServer(contentRepository, remoteFileRepository, vaultReader) : DeploymentFullReplaceHandler.createForStandalone(contentRepository, vaultReader);
        root.registerOperationHandler("full-replace-deployment", (OperationStepHandler)dfrh, (DescriptionProvider)dfrh, false);
        if (!isDomain) {
            SnapshotDeleteHandler snapshotDelete = new SnapshotDeleteHandler((ConfigurationPersister)extensibleConfigurationPersister);
            root.registerOperationHandler("delete-snapshot", (OperationStepHandler)snapshotDelete, (DescriptionProvider)snapshotDelete, false);
            SnapshotListHandler snapshotList = new SnapshotListHandler((ConfigurationPersister)extensibleConfigurationPersister);
            root.registerOperationHandler("list-snapshots", (OperationStepHandler)snapshotList, (DescriptionProvider)snapshotList, false);
            SnapshotTakeHandler snapshotTake = new SnapshotTakeHandler((ConfigurationPersister)extensibleConfigurationPersister);
            root.registerOperationHandler("take-snapshot", (OperationStepHandler)snapshotTake, (DescriptionProvider)snapshotTake, false);
        }
        root.registerOperationHandler("server-set-restart-required", (OperationStepHandler)ServerRestartRequiredHandler.INSTANCE, (DescriptionProvider)ServerRestartRequiredHandler.INSTANCE, false);
        root.registerReadOnlyAttribute("server-state", (OperationStepHandler)new ProcessStateAttributeHandler(processState), AttributeAccess.Storage.RUNTIME);
        root.registerReadOnlyAttribute("process-type", (OperationStepHandler)ProcessTypeHandler.INSTANCE, AttributeAccess.Storage.RUNTIME);
        RunningModeReadHandler.createAndRegister(runningModeControl, root);
        root.registerOperationHandler("resolve-expression", (OperationStepHandler)ResolveExpressionHandler.INSTANCE, (DescriptionProvider)ResolveExpressionHandler.INSTANCE, EnumSet.of(OperationEntry.Flag.READ_ONLY, OperationEntry.Flag.RUNTIME_ONLY));
        root.registerOperationHandler("resolve-internet-address", (OperationStepHandler)SpecifiedInterfaceResolveHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceResolveHandler.INSTANCE, runtimeOnlyFlag);
        root.registerOperationHandler("whoami", (OperationStepHandler)WhoAmIOperation.INSTANCE, (DescriptionProvider)WhoAmIOperation.INSTANCE, true);
        root.registerOperationHandler("root-resource-hack", (OperationStepHandler)RootResourceHack.INSTANCE, (DescriptionProvider)RootResourceHack.INSTANCE, false, OperationEntry.EntryType.PRIVATE, runtimeOnlyFlag);
        if (serverEnvironment != null) {
            if (serverEnvironment.getLaunchType() != ServerEnvironment.LaunchType.DOMAIN) {
                ProcessReloadHandler reloadHandler = new ProcessReloadHandler(Services.JBOSS_AS, runningModeControl, processState, ServerDescriptions.getResourceDescriptionResolver("server"));
                root.registerOperationHandler("reload", (OperationStepHandler)reloadHandler, (DescriptionProvider)reloadHandler);
            }
            if (serverEnvironment.getLaunchType() == ServerEnvironment.LaunchType.STANDALONE) {
                ServerShutdownHandler serverShutdownHandler = new ServerShutdownHandler(processState);
                root.registerOperationHandler("shutdown", (OperationStepHandler)serverShutdownHandler, (DescriptionProvider)serverShutdownHandler);
            }
            root.registerReadOnlyAttribute("launch-type", (OperationStepHandler)new LaunchTypeHandler(serverEnvironment.getLaunchType()), AttributeAccess.Storage.RUNTIME);
            root.registerSubModel((ResourceDefinition)ServerEnvironmentResourceDescription.of(serverEnvironment));
        }
        ManagementResourceRegistration sysProps = root.registerSubModel(PathElement.pathElement((String)"system-property"), ServerDescriptionProviders.SYSTEM_PROPERTIES_PROVIDER);
        SystemPropertyAddHandler spah = new SystemPropertyAddHandler((ProcessEnvironment)serverEnvironment, false);
        sysProps.registerOperationHandler("add", (OperationStepHandler)spah, (DescriptionProvider)spah, false);
        SystemPropertyRemoveHandler sprh = new SystemPropertyRemoveHandler((ProcessEnvironment)serverEnvironment);
        sysProps.registerOperationHandler("remove", (OperationStepHandler)sprh, (DescriptionProvider)sprh, false);
        SystemPropertyValueWriteAttributeHandler spvwah = new SystemPropertyValueWriteAttributeHandler((ProcessEnvironment)serverEnvironment);
        sysProps.registerReadWriteAttribute("value", null, (OperationStepHandler)spvwah, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration vault = root.registerSubModel(PathElement.pathElement((String)"core-service", (String)"vault"), CommonProviders.VAULT_PROVIDER);
        VaultAddHandler vah = new VaultAddHandler(vaultReader);
        vault.registerOperationHandler("add", (OperationStepHandler)vah, (DescriptionProvider)vah, false);
        VaultRemoveHandler vrh = new VaultRemoveHandler(vaultReader);
        vault.registerOperationHandler("remove", (OperationStepHandler)vrh, (DescriptionProvider)vrh, false);
        VaultWriteAttributeHandler.INSTANCE.registerAttributes(vault);
        ManagementResourceRegistration management = root.registerSubModel(PathElement.pathElement((String)"core-service", (String)"management"), CommonProviders.MANAGEMENT_WITH_INTERFACES_PROVIDER);
        management.registerSubModel((ResourceDefinition)SecurityRealmResourceDefinition.INSTANCE);
        management.registerSubModel((ResourceDefinition)LdapConnectionResourceDefinition.INSTANCE);
        management.registerSubModel((ResourceDefinition)NativeManagementResourceDefinition.INSTANCE);
        management.registerSubModel((ResourceDefinition)NativeRemotingManagementResourceDefinition.INSTANCE);
        management.registerSubModel((ResourceDefinition)HttpManagementResourceDefinition.INSTANCE);
        ManagementResourceRegistration serviceContainer = root.registerSubModel(PathElement.pathElement((String)"core-service", (String)"service-container"), CommonProviders.SERVICE_CONTAINER_PROVIDER);
        serviceContainer.registerOperationHandler("dump-services", (OperationStepHandler)DumpServicesHandler.INSTANCE, (DescriptionProvider)DumpServicesHandler.INSTANCE, false, runtimeOnlyFlag);
        PlatformMBeanResourceRegistrar.registerPlatformMBeanResources((ManagementResourceRegistration)root);
        root.registerSubModel((ResourceDefinition)PathResourceDefinition.createSpecified((PathManagerService)pathManager));
        ManagementResourceRegistration interfaces = root.registerSubModel(PathElement.pathElement((String)"interface"), CommonProviders.SPECIFIED_INTERFACE_PROVIDER);
        interfaces.registerOperationHandler("add", (OperationStepHandler)SpecifiedInterfaceAddHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceAddHandler.INSTANCE, false);
        interfaces.registerOperationHandler("remove", (OperationStepHandler)SpecifiedInterfaceRemoveHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceRemoveHandler.INSTANCE, false);
        InterfaceCriteriaWriteHandler.UPDATE_RUNTIME.register(interfaces);
        interfaces.registerReadOnlyAttribute("resolved-address", NetworkInterfaceRuntimeHandler.INSTANCE, AttributeAccess.Storage.RUNTIME);
        interfaces.registerOperationHandler("resolve-internet-address", (OperationStepHandler)SpecifiedInterfaceResolveHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceResolveHandler.INSTANCE, runtimeOnlyFlag);
        ManagementResourceRegistration socketGroup = root.registerSubModel((ResourceDefinition)new SocketBindingGroupResourceDefinition((OperationStepHandler)BindingGroupAddHandler.INSTANCE, (OperationStepHandler)BindingGroupRemoveHandler.INSTANCE, false));
        socketGroup.registerSubModel((ResourceDefinition)SocketBindingResourceDefinition.INSTANCE);
        socketGroup.registerSubModel((ResourceDefinition)RemoteDestinationOutboundSocketBindingResourceDefinition.INSTANCE);
        socketGroup.registerSubModel((ResourceDefinition)LocalDestinationOutboundSocketBindingResourceDefinition.INSTANCE);
        ManagementResourceRegistration deployments = root.registerSubModel(PathElement.pathElement((String)"deployment"), ServerDescriptionProviders.DEPLOYMENT_PROVIDER);
        DeploymentAddHandler dah = isDomain ? DeploymentAddHandler.createForDomainServer(contentRepository, remoteFileRepository, vaultReader) : DeploymentAddHandler.createForStandalone(contentRepository, vaultReader);
        deployments.registerOperationHandler("add", (OperationStepHandler)dah, (DescriptionProvider)dah, false);
        DeploymentRemoveHandler dremh = new DeploymentRemoveHandler(contentRepository, vaultReader);
        deployments.registerOperationHandler("remove", (OperationStepHandler)dremh, (DescriptionProvider)dremh, false);
        DeploymentDeployHandler ddhu = new DeploymentDeployHandler(vaultReader);
        deployments.registerOperationHandler("deploy", (OperationStepHandler)ddhu, (DescriptionProvider)ddhu, false);
        DeploymentUndeployHandler duh = new DeploymentUndeployHandler(vaultReader);
        deployments.registerOperationHandler("undeploy", (OperationStepHandler)duh, (DescriptionProvider)duh, false);
        DeploymentRedeployHandler drdh = new DeploymentRedeployHandler(vaultReader);
        deployments.registerOperationHandler("redeploy", (OperationStepHandler)drdh, (DescriptionProvider)drdh, false);
        deployments.registerMetric("status", DeploymentStatusHandler.INSTANCE);
        deployments.registerSubModel(PathElement.pathElement((String)"subdeployment"), ServerDescriptionProviders.SUBDEPLOYMENT_PROVIDER);
        root.registerSubModel((ResourceDefinition)new ExtensionResourceDefinition(extensionRegistry, parallelBoot, false));
        extensionRegistry.setSubsystemParentResourceRegistrations(root, deployments);
        extensionRegistry.setPathManager((PathManager)pathManager);
        root.registerOperationHandler("add-deployer-chains", (OperationStepHandler)DeployerChainAddHandler.INSTANCE, (DescriptionProvider)DeployerChainAddHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
    }

    static ProcessType getProcessType(ServerEnvironment serverEnvironment) {
        if (serverEnvironment != null) {
            switch (serverEnvironment.getLaunchType()) {
                case DOMAIN: {
                    return ProcessType.DOMAIN_SERVER;
                }
                case STANDALONE: {
                    return ProcessType.STANDALONE_SERVER;
                }
                case EMBEDDED: {
                    return ProcessType.EMBEDDED_SERVER;
                }
                case APPCLIENT: {
                    return ProcessType.APPLICATION_CLIENT;
                }
            }
        }
        return ProcessType.EMBEDDED_SERVER;
    }
}

