/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.threads.QueuelessThreadPoolService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.ThreadsSubsystemProviders;
import org.jboss.as.threads.ThreadsSubsystemThreadPoolOperationUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class QueuelessThreadPoolAdd
implements ModelAddOperationHandler,
DescriptionProvider {
    static final QueuelessThreadPoolAdd INSTANCE = new QueuelessThreadPoolAdd();

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        final ThreadsSubsystemThreadPoolOperationUtils.QueuelessOperationParameters params = ThreadsSubsystemThreadPoolOperationUtils.parseQueuelessThreadPoolOperationParameters(operation);
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ModelNode model = context.getSubModel();
        model.get("name").set(name);
        if (params.getThreadFactory() != null) {
            model.get("thread-factory").set(params.getThreadFactory());
        }
        if (params.getProperties() != null && params.getProperties().asList().size() > 0) {
            model.get("properties").set(params.getProperties());
        }
        if (params.getMaxThreads() != null) {
            model.get("max-threads").set(operation.get("max-threads"));
        }
        if (params.getKeepAliveTime() != null) {
            model.get("keepalive-time").set(operation.get("keepalive-time"));
        }
        model.get("blocking").set(params.isBlocking());
        if (params.getHandoffExecutor() != null) {
            model.get("handoff-executor").set(params.getHandoffExecutor());
        }
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget target = context.getServiceTarget();
                    ServiceName serviceName = ThreadsServices.executorName(params.getName());
                    QueuelessThreadPoolService service = new QueuelessThreadPoolService(params.getMaxThreads().getScaledCount(), params.isBlocking(), params.getKeepAliveTime());
                    ServiceBuilder serviceBuilder = target.addService(serviceName, (Service)service);
                    ThreadsSubsystemThreadPoolOperationUtils.addThreadFactoryDependency(params.getThreadFactory(), serviceName, serviceBuilder, service.getThreadFactoryInjector(), target, params.getName() + "-threads");
                    serviceBuilder.install();
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        ModelNode compensating = Util.getResourceRemoveOperation((ModelNode)params.getAddress());
        return new BasicOperationResult(compensating);
    }

    public ModelNode getModelDescription(Locale locale) {
        return ThreadsSubsystemProviders.ADD_QUEUELESS_THREAD_POOL_DESC.getModelDescription(locale);
    }
}

