/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.threads.ThreadFactoryService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public final class ThreadFactoryGroupNameUpdate
implements ModelUpdateOperationHandler {
    private static final long serialVersionUID = 4253625376544201028L;
    public static final ThreadFactoryGroupNameUpdate INSTANCE = new ThreadFactoryGroupNameUpdate();
    private final ParametersValidator validator = new ParametersValidator();

    private ThreadFactoryGroupNameUpdate() {
        this.validator.registerValidator("value", (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true, true));
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        String newGroupName;
        ModelNode newValue;
        this.validator.validate(operation);
        final String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
        ModelNode model = context.getSubModel();
        if (!model.isDefined()) {
            throw new OperationFailedException(this.notConfigured(name));
        }
        ModelNode oldValue = model.get("group-name");
        if (operation.hasDefined("value")) {
            newValue = operation.get("value");
            newGroupName = newValue.resolve().asString();
        } else {
            newValue = new ModelNode();
            newGroupName = null;
        }
        model.get("group-name").set(newValue);
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceController service = context.getServiceRegistry().getService(ThreadsServices.threadFactoryName(name));
                    if (service == null) {
                        throw new OperationFailedException(ThreadFactoryGroupNameUpdate.this.notConfigured(name));
                    }
                    ThreadFactoryService threadFactoryService = (ThreadFactoryService)service.getValue();
                    threadFactoryService.setThreadGroupName(newGroupName);
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        ModelNode compensatingOp = operation.clone();
        compensatingOp.get("value").set(oldValue);
        return new BasicOperationResult(compensatingOp);
    }

    private ModelNode notConfigured(String name) {
        return new ModelNode().set(String.format("No thread factory named %s is configured", name));
    }
}

