/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.threads.TimeSpec;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.EventListener;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.JBossThreadPoolExecutor;

public class UnboundedQueueThreadPoolService
implements Service<ExecutorService> {
    private final InjectedValue<ThreadFactory> threadFactoryValue = new InjectedValue();
    private JBossThreadPoolExecutor executor;
    private ExecutorService value;
    private int maxThreads;
    private TimeSpec keepAlive;

    public UnboundedQueueThreadPoolService(int maxThreads, TimeSpec keepAlive) {
        this.maxThreads = maxThreads;
        this.keepAlive = keepAlive;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.executor = new JBossThreadPoolExecutor(this.maxThreads, this.maxThreads, this.keepAlive.getDuration(), this.keepAlive.getUnit(), new LinkedBlockingQueue(), (ThreadFactory)this.threadFactoryValue.getValue());
        this.value = JBossExecutors.protectedExecutorService((Executor)this.executor);
    }

    public synchronized void stop(StopContext context) {
        JBossThreadPoolExecutor executor = this.executor;
        if (executor == null) {
            throw new IllegalStateException();
        }
        context.asynchronous();
        executor.shutdown();
        executor.addShutdownListener((EventListener)new EventListener<StopContext>(){

            public void handleEvent(StopContext stopContext) {
                stopContext.complete();
            }
        }, (Object)context);
        this.executor = null;
        this.value = null;
    }

    public synchronized ExecutorService getValue() throws IllegalStateException {
        ExecutorService value = this.value;
        if (value == null) {
            throw new IllegalStateException();
        }
        return value;
    }

    public Injector<ThreadFactory> getThreadFactoryInjector() {
        return this.threadFactoryValue;
    }

    public synchronized void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        JBossThreadPoolExecutor executor = this.executor;
        if (executor != null) {
            executor.setMaxThreads(maxThreads);
        }
    }

    public synchronized void setKeepAlive(TimeSpec keepAlive) {
        this.keepAlive = keepAlive;
        JBossThreadPoolExecutor executor = this.executor;
        if (executor != null) {
            executor.setKeepAliveTime(keepAlive.getDuration(), keepAlive.getUnit());
        }
    }
}

