/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn;

import com.arjuna.ats.arjuna.common.CoordinatorEnvironmentBean;
import com.arjuna.ats.arjuna.common.CoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBrowser;
import com.arjuna.ats.internal.jta.recovery.arjunacore.JTANodeNameXAResourceOrphanFilter;
import com.arjuna.ats.internal.jta.recovery.arjunacore.JTATransactionLogXAResourceOrphanFilter;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionSynchronizationRegistryImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.UserTransactionImple;
import com.arjuna.ats.jbossatx.jta.TransactionManagerDelegate;
import com.arjuna.ats.jbossatx.jts.TransactionManagerService;
import com.arjuna.ats.jta.common.JTAEnvironmentBean;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.server.services.net.SocketBinding;
import org.jboss.as.txn.SecurityActions;
import org.jboss.as.txn.TxnServices;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.tm.JBossXATerminator;
import org.jboss.tm.LastResource;
import org.omg.CORBA.ORB;

final class ArjunaTransactionManagerService
implements Service<com.arjuna.ats.jbossatx.jta.TransactionManagerService> {
    public static final ServiceName SERVICE_NAME = TxnServices.JBOSS_TXN_ARJUNA_TRANSACTION_MANAGER;
    private final InjectedValue<JBossXATerminator> xaTerminatorInjector = new InjectedValue();
    private final InjectedValue<ORB> orbInjector = new InjectedValue();
    private final InjectedValue<SocketBinding> socketProcessBindingInjector = new InjectedValue();
    private com.arjuna.ats.jbossatx.jta.TransactionManagerService value;
    private ObjStoreBrowser objStoreBrowser;
    private String coreNodeIdentifier;
    private int coreSocketProcessIdMaxPorts;
    private boolean coordinatorEnableStatistics;
    private int coordinatorDefaultTimeout;

    ArjunaTransactionManagerService(String coreNodeIdentifier, int coreSocketProcessIdMaxPorts, boolean coordinatorEnableStatistics, int coordinatorDefaultTimeout) {
        this.coreNodeIdentifier = coreNodeIdentifier;
        this.coreSocketProcessIdMaxPorts = coreSocketProcessIdMaxPorts;
        this.coordinatorEnableStatistics = coordinatorEnableStatistics;
        this.coordinatorDefaultTimeout = coordinatorDefaultTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext context) throws StartException {
        SecurityActions.setContextLoader(ArjunaTransactionManagerService.class.getClassLoader());
        try {
            com.arjuna.ats.jbossatx.jta.TransactionManagerService service;
            CoreEnvironmentBean coreEnvironmentBean = arjPropertyManager.getCoreEnvironmentBean();
            coreEnvironmentBean.setSocketProcessIdPort(((SocketBinding)this.socketProcessBindingInjector.getValue()).getSocketAddress().getPort());
            coreEnvironmentBean.setNodeIdentifier(this.coreNodeIdentifier);
            coreEnvironmentBean.setSocketProcessIdMaxPorts(this.coreSocketProcessIdMaxPorts);
            JTAEnvironmentBean jtaEnvironmentBean = jtaPropertyManager.getJTAEnvironmentBean();
            jtaEnvironmentBean.setLastResourceOptimisationInterfaceClassName(LastResource.class.getName());
            jtaEnvironmentBean.setXaRecoveryNodes(Collections.singletonList("1"));
            jtaEnvironmentBean.setXaResourceOrphanFilterClassNames(Arrays.asList(JTATransactionLogXAResourceOrphanFilter.class.getName(), JTANodeNameXAResourceOrphanFilter.class.getName()));
            CoordinatorEnvironmentBean coordinatorEnvironmentBean = arjPropertyManager.getCoordinatorEnvironmentBean();
            coordinatorEnvironmentBean.setEnableStatistics(this.coordinatorEnableStatistics);
            coordinatorEnvironmentBean.setDefaultTimeout(this.coordinatorDefaultTimeout);
            HashMap<String, String> objStoreBrowserTypes = new HashMap<String, String>();
            this.objStoreBrowser = new ObjStoreBrowser();
            objStoreBrowserTypes.put("StateManager/BasicAction/TwoPhaseCoordinator/AtomicAction", "com.arjuna.ats.internal.jta.tools.osb.mbean.jta.JTAActionBean");
            ORB orb = (ORB)this.orbInjector.getValue();
            if (orb == null) {
                service = new com.arjuna.ats.jbossatx.jta.TransactionManagerService();
                service.setJbossXATerminator((JBossXATerminator)this.xaTerminatorInjector.getValue());
                service.setTransactionSynchronizationRegistry((TransactionSynchronizationRegistry)new TransactionSynchronizationRegistryImple());
                jtaEnvironmentBean.setTransactionManagerClassName(TransactionManagerDelegate.class.getName());
                jtaEnvironmentBean.setUserTransactionClassName(UserTransactionImple.class.getName());
                jtaEnvironmentBean.setTransactionSynchronizationRegistryClassName(TransactionSynchronizationRegistryImple.class.getName());
                try {
                    service.create();
                }
                catch (Exception e) {
                    throw new StartException("Transaction manager create failed", (Throwable)e);
                }
                service.start();
                this.value = service;
            } else {
                service = new TransactionManagerService();
                service.setJbossXATerminator((JBossXATerminator)this.xaTerminatorInjector.getValue());
                service.setTransactionSynchronizationRegistry((TransactionSynchronizationRegistry)new com.arjuna.ats.internal.jta.transaction.jts.TransactionSynchronizationRegistryImple());
                jtaEnvironmentBean.setTransactionManagerClassName(com.arjuna.ats.jbossatx.jts.TransactionManagerDelegate.class.getName());
                jtaEnvironmentBean.setUserTransactionClassName(com.arjuna.ats.internal.jta.transaction.jts.UserTransactionImple.class.getName());
                jtaEnvironmentBean.setTransactionSynchronizationRegistryClassName(TransactionSynchronizationRegistryImple.class.getName());
                objStoreBrowserTypes.put("StateManager/BasicAction/TwoPhaseCoordinator/ArjunaTransactionImple", "com.arjuna.ats.arjuna.tools.osb.mbean.ActionBean");
                try {
                    service.create();
                }
                catch (Exception e) {
                    throw new StartException("Create failed", (Throwable)e);
                }
                try {
                    service.start(orb);
                }
                catch (Exception e) {
                    throw new StartException("Start failed", (Throwable)e);
                }
                this.value = service;
            }
            try {
                this.objStoreBrowser.setTypes(objStoreBrowserTypes);
                this.objStoreBrowser.start();
            }
            catch (Exception e) {
                throw new StartException("Failed to configure object store browser bean", (Throwable)e);
            }
        }
        finally {
            SecurityActions.setContextLoader(null);
        }
    }

    public synchronized void stop(StopContext context) {
        this.value.stop();
        this.value.destroy();
        this.objStoreBrowser.stop();
        this.value = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized com.arjuna.ats.jbossatx.jta.TransactionManagerService getValue() throws IllegalStateException {
        SecurityActions.setContextLoader(ArjunaTransactionManagerService.class.getClassLoader());
        try {
            com.arjuna.ats.jbossatx.jta.TransactionManagerService transactionManagerService = TxnServices.notNull(this.value);
            return transactionManagerService;
        }
        finally {
            SecurityActions.setContextLoader(null);
        }
    }

    Injector<JBossXATerminator> getXaTerminatorInjector() {
        return this.xaTerminatorInjector;
    }

    Injector<ORB> getOrbInjector() {
        return this.orbInjector;
    }

    Injector<SocketBinding> getSocketProcessBindingInjector() {
        return this.socketProcessBindingInjector;
    }
}

