/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn;

import com.arjuna.ats.arjuna.coordinator.TxStats;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;

public class TxStatsHandler
implements OperationStepHandler {
    public static final TxStatsHandler INSTANCE = new TxStatsHandler();
    private final TxStats txStats = TxStats.getInstance();
    private final ParametersValidator validator = new ParametersValidator();

    private TxStatsHandler() {
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        TxStat stat = TxStat.getStat(operation.require("name").asString());
        if (stat == null) {
            context.getFailureDescription().set(String.format("Unknown metric %s", operation.require("name").asString()));
        } else {
            ModelNode result = new ModelNode();
            switch (stat) {
                case NUMBER_OF_TRANSACTIONS: {
                    result.set(this.txStats.getNumberOfTransactions());
                    break;
                }
                case NUMBER_OF_NESTED_TRANSACTIONS: {
                    result.set(this.txStats.getNumberOfNestedTransactions());
                    break;
                }
                case NUMBER_OF_HEURISTICS: {
                    result.set(this.txStats.getNumberOfHeuristics());
                    break;
                }
                case NUMBER_OF_COMMITTED_TRANSACTIONS: {
                    result.set(this.txStats.getNumberOfCommittedTransactions());
                    break;
                }
                case NUMBER_OF_ABORTED_TRANSACTIONS: {
                    result.set(this.txStats.getNumberOfAbortedTransactions());
                    break;
                }
                case NUMBER_OF_INFLIGHT_TRANSACTIONS: {
                    result.set(this.txStats.getNumberOfInflightTransactions());
                    break;
                }
                case NUMBER_OF_TIMED_OUT_TRANSACTIONS: {
                    result.set(this.txStats.getNumberOfTimedOutTransactions());
                    break;
                }
                case NUMBER_OF_APPLICATION_ROLLBACKS: {
                    result.set(this.txStats.getNumberOfApplicationRollbacks());
                    break;
                }
                case NUMBER_OF_RESOURCE_ROLLBACKS: {
                    result.set(this.txStats.getNumberOfResourceRollbacks());
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unknown metric %s", new Object[]{stat}));
                }
            }
            context.getResult().set(result);
        }
        context.completeStep();
    }

    public static enum TxStat {
        NUMBER_OF_TRANSACTIONS("number-of-transactions"),
        NUMBER_OF_NESTED_TRANSACTIONS("number-of-nested-transactions"),
        NUMBER_OF_HEURISTICS("number-of-heuristics"),
        NUMBER_OF_COMMITTED_TRANSACTIONS("number-of-committed-transactions"),
        NUMBER_OF_ABORTED_TRANSACTIONS("number-of-aborted-transactions"),
        NUMBER_OF_INFLIGHT_TRANSACTIONS("number-of-inflight-transactions"),
        NUMBER_OF_TIMED_OUT_TRANSACTIONS("number-of-timed-out-transactions"),
        NUMBER_OF_APPLICATION_ROLLBACKS("number-of-application-rollbacks"),
        NUMBER_OF_RESOURCE_ROLLBACKS("number-of-resource-rollbacks");

        private static final Map<String, TxStat> MAP;
        private String stringForm;

        private TxStat(String stringForm) {
            this.stringForm = stringForm;
        }

        public final String toString() {
            return this.stringForm;
        }

        public static synchronized TxStat getStat(String stringForm) {
            return MAP.get(stringForm);
        }

        static {
            MAP = new HashMap<String, TxStat>();
            for (TxStat stat : EnumSet.allOf(TxStat.class)) {
                MAP.put(stat.toString(), stat);
            }
        }
    }
}

