/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.txn.subsystem.LogStoreResource;
import org.jboss.as.txn.subsystem.TransactionExtension;
import org.jboss.dmr.ModelNode;

public class LogStoreTransactionDeleteHandler
implements OperationStepHandler {
    static final String LOG_DELETE_FAILURE_MESSAGE = "Unable to remove transaction log";
    private LogStoreResource logStoreResource = null;

    LogStoreTransactionDeleteHandler(LogStoreResource resource) {
        this.logStoreResource = resource;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        MBeanServer mbs = TransactionExtension.getMBeanServer(context);
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        try {
            ObjectName on = LogStoreResource.getObjectName(resource);
            Object res = mbs.invoke(on, "remove", null, null);
            try {
                mbs.getObjectInstance(on);
                String reason = res != null ? res.toString() : LOG_DELETE_FAILURE_MESSAGE;
                throw new OperationFailedException(reason);
            }
            catch (InstanceNotFoundException e) {
                PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                PathElement element = address.getLastElement();
                context.acquireControllerLock();
                this.logStoreResource.removeChild(element);
                context.completeStep();
            }
        }
        catch (Exception e) {
            throw new OperationFailedException(e.getMessage());
        }
    }
}

