/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.webservices.dmr.Element;
import org.jboss.as.webservices.dmr.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

final class WebservicesSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    private static final WebservicesSubsystemParser INSTANCE = new WebservicesSubsystemParser();

    WebservicesSubsystemParser() {
    }

    static WebservicesSubsystemParser getInstance() {
        return INSTANCE;
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        this.writeElement(writer, Element.WSDL_HOST, node.require("wsdl-host"));
        this.writeElement(writer, Element.MODIFY_WSDL_ADDRESS, node.require("modify-wsdl-address"));
        if (this.has(node, "wsdl-secure-port")) {
            this.writeElement(writer, Element.WSDL_SECURE_PORT, node.require("wsdl-secure-port"));
        }
        if (this.has(node, "wsdl-port")) {
            this.writeElement(writer, Element.WSDL_PORT, node.require("wsdl-port"));
        }
        writer.writeEndElement();
    }

    private boolean has(ModelNode node, String name) {
        return node.has(name) && node.get(name).isDefined();
    }

    private void writeElement(XMLExtendedStreamWriter writer, Element element, ModelNode value) throws XMLStreamException {
        writer.writeStartElement(element.getLocalName());
        writer.writeCharacters(value.asString());
        writer.writeEndElement();
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", "webservices");
        EnumSet<Element> required = EnumSet.of(Element.MODIFY_WSDL_ADDRESS, Element.WSDL_HOST);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEBSERVICES_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    required.remove((Object)element);
                    if (!encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case WSDL_HOST: {
                            subsystem.get("wsdl-host").set(this.parseElementNoAttributes(reader));
                            continue block9;
                        }
                        case MODIFY_WSDL_ADDRESS: {
                            boolean b = Boolean.parseBoolean(this.parseElementNoAttributes(reader));
                            subsystem.get("modify-wsdl-address").set(b);
                            continue block9;
                        }
                        case WSDL_SECURE_PORT: {
                            int port = Integer.valueOf(this.parseElementNoAttributes(reader));
                            subsystem.get("wsdl-secure-port").set(port);
                            continue block9;
                        }
                        case WSDL_PORT: {
                            int port = Integer.valueOf(this.parseElementNoAttributes(reader));
                            subsystem.get("wsdl-port").set(port);
                            continue block9;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, required);
        }
        list.add(subsystem);
    }

    private String parseElementNoAttributes(XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        return reader.getElementText().trim();
    }
}

