/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import javax.management.MBeanServer;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.webservices.config.ServerConfigImpl;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.ws.common.management.AbstractServerConfig;
import org.jboss.wsf.spi.management.ServerConfig;

public final class ServerConfigService
implements Service<ServerConfig> {
    private static final Logger log = Logger.getLogger(ServerConfigService.class);
    private static final ServiceName MBEAN_SERVER_NAME = ServiceName.JBOSS.append(new String[]{"mbean", "server"});
    private final AbstractServerConfig serverConfig;

    private ServerConfigService(AbstractServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public ServerConfig getValue() {
        return this.serverConfig;
    }

    public void start(StartContext context) throws StartException {
        log.tracef("Starting %s", (Object)ServerConfigService.class.getName());
        try {
            this.serverConfig.create();
        }
        catch (Exception e) {
            log.fatal((Object)"Error while creating configuration service", (Throwable)e);
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        log.tracef("Stopping %s", (Object)ServerConfigService.class.getName());
        try {
            this.serverConfig.destroy();
        }
        catch (Exception e) {
            log.error((Object)"Error while destroying configuration service", (Throwable)e);
        }
    }

    public static void install(ServiceTarget serviceTarget, ServerConfigImpl serverConfig) {
        ServiceBuilder builder = serviceTarget.addService(WSServices.CONFIG_SERVICE, (Service)new ServerConfigService(serverConfig));
        builder.addDependency(ServiceBuilder.DependencyType.REQUIRED, MBEAN_SERVER_NAME, MBeanServer.class, serverConfig.getMBeanServerInjector());
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, serverConfig.getServerEnvironmentInjector());
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        builder.install();
    }
}

