/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.weld.WeldSubsystemAdd;
import org.jboss.as.weld.WeldSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class WeldExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.weld");
    public static final String SUBSYSTEM_NAME = "weld";
    public static final String NAMESPACE = "urn:jboss:domain:weld:1.0";
    private static final WeldSubsystemParser parser = new WeldSubsystemParser();
    static final DescriptionProvider SUBSYSTEM_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return WeldSubsystemProviders.getSubsystemDescription(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return WeldSubsystemProviders.getSubsystemAddDescription(locale);
        }
    };

    public void initialize(ExtensionContext context) {
        log.debug((Object)"Activating Weld Extension");
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ModelNodeRegistration registration = subsystem.registerSubsystemModel(SUBSYSTEM_DESCRIPTION);
        registration.registerOperationHandler("add", (OperationHandler)WeldSubsystemAdd.INSTANCE, SUBSYSTEM_ADD_DESCRIPTION, false);
        registration.registerOperationHandler("describe", (OperationHandler)WeldSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)WeldSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerXMLElementWriter((XMLElementWriter)parser);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(NAMESPACE, (XMLElementReader)parser);
    }

    private static ModelNode createAddSubSystemOperation() {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", SUBSYSTEM_NAME);
        return subsystem;
    }

    private static class WeldSubsystemDescribeHandler
    implements ModelQueryOperationHandler,
    DescriptionProvider {
        static final WeldSubsystemDescribeHandler INSTANCE = new WeldSubsystemDescribeHandler();

        private WeldSubsystemDescribeHandler() {
        }

        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
            ModelNode node = new ModelNode();
            node.add(WeldExtension.createAddSubSystemOperation());
            resultHandler.handleResultFragment(Util.NO_LOCATION, node);
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    static class WeldSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        WeldSubsystemParser() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            list.add(WeldExtension.createAddSubSystemOperation());
        }

        public void writeContent(XMLExtendedStreamWriter streamWriter, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(WeldExtension.NAMESPACE, false);
            streamWriter.writeEndElement();
        }
    }
}

