/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment;

import java.io.Serializable;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.weld.deployment.EjbDescriptorImpl;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.weld.ejb.api.SessionObjectReference;

public class SessionObjectReferenceImpl
implements SessionObjectReference {
    private final EjbDescriptorImpl<?> descriptor;
    private final ServiceRegistry serviceRegistry;
    private final Serializable sessionId;
    private volatile boolean removed = false;
    private volatile Component component;

    public SessionObjectReferenceImpl(EjbDescriptorImpl<?> descriptor, ServiceRegistry serviceRegistry) {
        this.descriptor = descriptor;
        this.serviceRegistry = serviceRegistry;
        ServiceName createServiceName = descriptor.getCreateServiceName();
        ServiceController controller = serviceRegistry.getRequiredService(createServiceName);
        this.component = (Component)controller.getValue();
        if (descriptor.isStateful()) {
            StatefulSessionComponent sfsb = (StatefulSessionComponent)this.component;
            this.sessionId = sfsb.createSession();
        } else {
            this.sessionId = null;
        }
    }

    public <S> S getBusinessObject(Class<S> businessInterfaceType) {
        ServiceName viewServiceName = (ServiceName)this.component.getViewServices().get(businessInterfaceType);
        if (viewServiceName == null) {
            throw new RuntimeException("Could not find view for " + businessInterfaceType);
        }
        ServiceController viewController = this.serviceRegistry.getRequiredService(viewServiceName);
        ComponentView view = (ComponentView)viewController.getValue();
        if (this.descriptor.isStateful()) {
            return (S)view.getViewForInstance(this.sessionId);
        }
        return (S)view.getReference().getInstance();
    }

    public void remove() {
        if (this.descriptor.isStateful()) {
            // empty if block
        }
        this.removed = true;
    }

    public boolean isRemoved() {
        return this.removed;
    }
}

