/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;

public class ModulesPath {
    @Parameter(alias="paths")
    private File[] paths;
    private File modulePath;

    public synchronized String get() {
        if (this.paths == null && this.modulePath == null) {
            return null;
        }
        if (this.paths == null) {
            return this.modulePath.getAbsolutePath();
        }
        StringBuilder result = new StringBuilder();
        if (this.modulePath != null) {
            result.append(this.modulePath.getAbsolutePath()).append(File.pathSeparatorChar);
        }
        for (int i = 0; i < this.paths.length; ++i) {
            result.append(this.paths[i].getAbsolutePath());
            if (i + 1 >= this.paths.length) continue;
            result.append(File.pathSeparatorChar);
        }
        return result.toString();
    }

    public synchronized List<String> validate() {
        if (this.paths == null && this.modulePath == null) {
            return Collections.emptyList();
        }
        ArrayList<File> files = new ArrayList<File>();
        if (this.modulePath != null) {
            files.add(this.modulePath);
        }
        if (this.paths != null) {
            Collections.addAll(files, this.paths);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (File file : files) {
            if (file.exists() && file.isDirectory()) continue;
            result.add(file.getAbsolutePath());
        }
        return result;
    }

    public synchronized void set(File modulePath) {
        this.modulePath = modulePath;
    }
}

