/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AdjListJDBCCacheLoader;
import org.jboss.cache.loader.AdjListJDBCCacheLoaderConfig;
import org.jboss.cache.loader.JDBCCacheLoaderConfig;
import org.jboss.cache.marshall.NodeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class JDBCCacheLoader
extends AdjListJDBCCacheLoader {
    private static final Log log = LogFactory.getLog(JDBCCacheLoader.class);
    private JDBCCacheLoaderConfig config;

    @Override
    protected AdjListJDBCCacheLoaderConfig processConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.config = base instanceof JDBCCacheLoaderConfig ? (JDBCCacheLoaderConfig)base : new JDBCCacheLoaderConfig(base);
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Fqn name, Object key, Object value) throws Exception {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("put name=" + name + " key=" + key + " value=" + value));
        }
        this.lock.acquireLock(name, true);
        try {
            Map<Object, Object> existing = this.loadNode(name);
            if (existing == null) {
                HashMap<Object, Object> m = new HashMap<Object, Object>(1);
                m.put(key, value);
                this.addNewSubtree(name, m);
                Object var6_8 = null;
                return var6_8;
            }
            if (existing == NULL_NODE_IN_ROW) {
                HashMap<Object, Object> m = new HashMap<Object, Object>(1);
                m.put(key, value);
                this.updateNode(name, m);
                Object var6_9 = null;
                return var6_9;
            }
            Object oldVal = existing.put(key, value);
            this.updateNode(name, existing);
            Object object = oldVal;
            return object;
        }
        finally {
            this.lock.releaseLock(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Fqn name, Map attributes) throws Exception {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("put name=" + name + " attr=" + attributes));
        }
        this.lock.acquireLock(name, true);
        HashMap<Object, Object> toStore = attributes;
        if (toStore != null && !(toStore instanceof HashMap)) {
            toStore = new HashMap<Object, Object>(attributes);
        }
        try {
            if (!this.exists(name)) {
                this.addNewSubtree(name, toStore);
            } else {
                this.updateNode(name, toStore);
            }
        }
        finally {
            this.lock.releaseLock(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void storeStateHelper(Fqn subtree, List nodeData, boolean moveToBuddy) throws Exception {
        this.lock.acquireLock(subtree, true);
        Connection con = null;
        PreparedStatement ps = null;
        boolean autocommitPrev = true;
        int batchCaount = 0;
        try {
            Object aNodeData;
            NodeData nd;
            con = this.cf.getConnection();
            autocommitPrev = con.getAutoCommit();
            if (this.config.isBatchEnabled()) {
                con.setAutoCommit(false);
            }
            ps = this.prepareAndLogStatement(con, this.config.getInsertNodeSql(), new String[0]);
            Iterator i$ = nodeData.iterator();
            while (i$.hasNext() && !(nd = (NodeData)(aNodeData = i$.next())).isMarker()) {
                int[] result;
                Fqn fqn = moveToBuddy ? this.buddyFqnTransformer.getBackupFqn(subtree, nd.getFqn()) : nd.getFqn();
                HashMap attributes = nd.getAttributes() == null ? null : new HashMap(nd.getAttributes());
                this.populatePreparedStatementForInsert(fqn, attributes, ps);
                if (!this.config.isBatchEnabled()) {
                    if (ps.executeUpdate() == 1) continue;
                    throw new IllegalStateException("One and only one row must have been updated!");
                }
                ps.addBatch();
                if ((long)(++batchCaount) < this.config.getBatchSize()) continue;
                for (int aResult : result = ps.executeBatch()) {
                    if (aResult == 1 || aResult == -2) continue;
                    throw new IllegalStateException("Failure executing batch insert during state transfer!");
                }
                batchCaount = 0;
            }
            if (batchCaount > 0) {
                if ((long)batchCaount > this.config.getBatchSize()) {
                    throw new IllegalStateException("batchCaount > config.getBatchSize() should never happen!");
                }
                ps.executeBatch();
            }
            this.lock.releaseLock(subtree);
            if (con == null) return;
        }
        catch (Throwable throwable) {
            this.lock.releaseLock(subtree);
            if (con == null) throw throwable;
            con.setAutoCommit(autocommitPrev);
            this.safeClose(ps);
            this.cf.close(con);
            throw throwable;
        }
        con.setAutoCommit(autocommitPrev);
        this.safeClose(ps);
        this.cf.close(con);
    }

    @Override
    public void remove(Fqn fqn) throws Exception {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            this.lock.acquireLock(fqn, true);
            conn = this.cf.getConnection();
            String fqnString = fqn.toString();
            String fqnWildcardString = this.getFqnWildcardString(fqnString, fqn);
            ps = this.prepareAndLogStatement(conn, this.config.getDeleteNodeSql(), fqnString, fqnWildcardString);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Failed to remove the node : " + fqn), (Throwable)e);
                throw new IllegalStateException("Failure while removing sub-tree (" + fqn + ")" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.safeClose(ps);
                this.cf.close(conn);
                this.lock.releaseLock(fqn);
                throw throwable;
            }
        }
        this.safeClose(ps);
        this.cf.close(conn);
        this.lock.releaseLock(fqn);
    }

    @Override
    protected void getNodeDataList(Fqn fqn, List<NodeData> list) throws Exception {
        Map<Object, Object> nodeAttributes = this.loadNode(fqn);
        if (nodeAttributes == null) {
            return;
        }
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = this.cf.getConnection();
            String fqnString = fqn.toString();
            String fqnWildcardString = this.getFqnWildcardString(fqnString, fqn);
            ps = this.prepareAndLogStatement(connection, this.config.getRecursiveChildrenSql(), fqnString, fqnWildcardString);
            rs = ps.executeQuery();
            while (rs.next()) {
                Map<Object, Object> attributes = this.readAttributes(rs, 2);
                Fqn<String> path = Fqn.fromString(rs.getString(1));
                NodeData<Object, Object> nodeData = attributes == null || attributes.isEmpty() ? new NodeData<Object, Object>(path) : new NodeData<Object, Object>(path, attributes, true);
                list.add(nodeData);
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Failed to load state for node(" + fqn + ") :" + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("Failed to load state for node(" + fqn + ") :" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.safeClose(rs);
                this.safeClose(ps);
                this.cf.close(connection);
                throw throwable;
            }
        }
        this.safeClose(rs);
        this.safeClose(ps);
        this.cf.close(connection);
    }

    private String getFqnWildcardString(String fqnString, Fqn fqn) {
        return this.escapeSqlLikeParameter(fqnString + (fqn.isRoot() ? "" : "/")) + '%';
    }

    private String escapeSqlLikeParameter(String res) {
        return res.replaceAll("([_%^])", "^$1");
    }

    private Map<Object, Object> readAttributes(ResultSet rs, int index) throws SQLException {
        Map result;
        InputStream is = rs.getBinaryStream(index);
        if (is != null && !rs.wasNull()) {
            try {
                Object marshalledNode = this.unmarshall(is);
                result = (Map)marshalledNode;
            }
            catch (Exception e) {
                log.error((Object)"Failure while reading attribute set from db", (Throwable)e);
                throw new SQLException("Failure while reading attribute set from db " + e);
            }
        } else {
            result = null;
        }
        return result;
    }

    private void addNewSubtree(Fqn name, Map attributes) throws Exception {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("addNewSubtree name=" + name + " attr=" + attributes));
        }
        Fqn currentNode = name;
        do {
            if (currentNode.equals(name)) {
                this.insertNode(currentNode, attributes, false);
                continue;
            }
            this.insertNode(currentNode, null, true);
        } while (!currentNode.isRoot() && !this.exists(currentNode = currentNode.getParent()));
    }

    @Override
    protected Log getLogger() {
        return log;
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (!this.exists(Fqn.ROOT) && this.getNodeCount() > 0) {
            this.put(Fqn.ROOT, (Map)null);
        }
    }

    public int getNodeCount() throws Exception {
        int n;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.cf.getConnection();
            ps = this.prepareAndLogStatement(conn, this.config.getNodeCountSql(), new String[0]);
            rs = ps.executeQuery();
            rs.next();
            n = rs.getInt(1);
        }
        catch (Exception e) {
            try {
                log.error((Object)("Failure while trying to get the count of persisted nodes: " + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("Failure while trying to get the count of persisted nodes: " + e.getMessage());
            }
            catch (Throwable throwable) {
                this.safeClose(rs);
                this.safeClose(ps);
                this.cf.close(conn);
                throw throwable;
            }
        }
        this.safeClose(rs);
        this.safeClose(ps);
        this.cf.close(conn);
        return n;
    }

    @Override
    public void storeState(Fqn subtree, ObjectInputStream in) throws Exception {
        super.storeState(subtree, in);
    }

    @Override
    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }
}

