/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.reports.model.api;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.jboss.da.model.rest.validators.ScmUrl;

public class SCMLocator {
    @ScmUrl
    @NonNull
    private String scmUrl;
    @NonNull
    private String revision;
    @NonNull
    private String pomPath;
    @NonNull
    private List<String> repositories = Collections.emptyList();

    private SCMLocator() {
    }

    private SCMLocator(String scmUrl, String revision, String pomPath, List<String> repositories) {
        this.scmUrl = Objects.requireNonNull(scmUrl);
        this.revision = Objects.requireNonNull(revision);
        this.pomPath = Objects.requireNonNull(pomPath);
        if (repositories != null) {
            this.repositories = repositories;
        }
    }

    public static SCMLocator internal(String scmUrl, String revision, String pomPath) {
        return SCMLocator.internal(scmUrl, revision, pomPath, null);
    }

    public static SCMLocator internal(String scmUrl, String revision, String pomPath, List<String> repositories) {
        SCMLocator ret = new SCMLocator(scmUrl, revision, pomPath, repositories);
        return ret;
    }

    public static SCMLocator generic(String scmUrl, String revision, String pomPath) {
        return SCMLocator.generic(scmUrl, revision, pomPath, Collections.emptyList());
    }

    public static SCMLocator generic(String scmUrl, String revision, String pomPath, List<String> repositories) {
        SCMLocator ret = new SCMLocator(scmUrl, revision, pomPath, repositories);
        return ret;
    }

    public String toString() {
        return "SCMLocator(scmUrl=" + this.getScmUrl() + ", revision=" + this.getRevision() + ", pomPath=" + this.getPomPath() + ", repositories=" + this.getRepositories() + ")";
    }

    @NonNull
    public String getScmUrl() {
        return this.scmUrl;
    }

    @NonNull
    public String getRevision() {
        return this.revision;
    }

    @NonNull
    public String getPomPath() {
        return this.pomPath;
    }

    @NonNull
    public List<String> getRepositories() {
        return this.repositories;
    }
}

