/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.deployer;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.spi.deployer.SecurityActions;
import org.jboss.deployers.vfs.spi.deployer.UnmarshallerFactory;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;
import org.jboss.xb.annotations.JBossXmlSchema;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossXBDeployerHelper<T>
implements UnmarshallerFactory<Boolean> {
    private Logger log = Logger.getLogger(JBossXBDeployerHelper.class);
    private static final org.jboss.xb.binding.UnmarshallerFactory factory = org.jboss.xb.binding.UnmarshallerFactory.newInstance();
    private static DefaultSchemaResolver resolver = (DefaultSchemaResolver)SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
    private Class<T> output;
    private boolean useSchemaValidation = true;
    private boolean useValidation = true;

    protected JBossXBDeployerHelper(Class<T> output) {
        if (output == null) {
            throw new IllegalArgumentException("Null output.");
        }
        this.output = output;
    }

    @Override
    public void setFeature(String featureName, Boolean flag) throws Exception {
        factory.setFeature(featureName, (Object)flag);
    }

    public boolean isUseSchemaValidation() {
        return this.useSchemaValidation;
    }

    public void setUseSchemaValidation(boolean useSchemaValidation) {
        this.useSchemaValidation = useSchemaValidation;
    }

    public boolean isUseValidation() {
        return this.useValidation;
    }

    public void setUseValidation(boolean useValidation) {
        this.useValidation = useValidation;
    }

    public static void addClassBinding(String namespace, Class<?> metadata) {
        resolver.addClassBinding(namespace, metadata);
    }

    public static void removeClassBinding(String namespace) {
        resolver.removeClassBinding(namespace);
    }

    public static String findNamespace(Class<?> metadata) {
        Package pckg;
        JBossXmlSchema jBossXmlSchema = metadata.getAnnotation(JBossXmlSchema.class);
        if (jBossXmlSchema == null && (pckg = metadata.getPackage()) != null) {
            jBossXmlSchema = pckg.getAnnotation(JBossXmlSchema.class);
        }
        return jBossXmlSchema != null ? jBossXmlSchema.namespace() : null;
    }

    public T parse(VirtualFile file) throws Exception {
        return this.parse(this.output, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> U parse(Class<U> expectedType, VirtualFile file) throws Exception {
        Object parsed;
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expected type");
        }
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        this.log.debug((Object)("Parsing file: " + file + " for type: " + expectedType));
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        unmarshaller.setSchemaValidation(this.isUseSchemaValidation());
        unmarshaller.setValidation(this.isUseValidation());
        InputStream is = JBossXBDeployerHelper.openStreamAndValidate(file);
        try {
            InputSource source = new InputSource(is);
            source.setSystemId(file.toURI().toString());
            parsed = unmarshaller.unmarshal(source, (SchemaBindingResolver)resolver);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception ignored) {}
        }
        if (parsed == null) {
            throw new DeploymentException("The xml " + file.getPathName() + " is not well formed!");
        }
        this.log.debug((Object)("Parsed file: " + file + " to: " + parsed));
        return expectedType.cast(parsed);
    }

    public T parse(VirtualFile file, T root, ObjectModelFactory omf) throws Exception {
        return this.parse(this.output, file, root, omf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> U parse(Class<U> expectedType, VirtualFile file, U root, ObjectModelFactory omf) throws Exception {
        Object parsed;
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        this.log.debug((Object)("Parsing file: " + file + " for deploymentType: " + expectedType));
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        unmarshaller.setSchemaValidation(this.isUseSchemaValidation());
        unmarshaller.setValidation(this.isUseValidation());
        InputStream is = JBossXBDeployerHelper.openStreamAndValidate(file);
        try {
            InputSource source = new InputSource(is);
            source.setSystemId(file.toURI().toString());
            parsed = unmarshaller.unmarshal(source, omf, root);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception ignored) {}
        }
        if (parsed == null) {
            throw new DeploymentException("The xml " + file.getPathName() + " is not well formed!");
        }
        this.log.debug((Object)("Parsed file: " + file + " to: " + parsed));
        return expectedType.cast(parsed);
    }

    protected static InputStream openStreamAndValidate(VirtualFile file) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        InputStream inputStream = SecurityActions.openStream(file);
        if (inputStream == null) {
            throw new IOException("Null file stream: " + file);
        }
        return inputStream;
    }
}

