/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import org.apache.commons.codec.binary.Base64;
import org.apache.cordova.DirectoryManager;
import org.apache.cordova.FileHelper;
import org.apache.cordova.api.CallbackContext;
import org.apache.cordova.api.CordovaPlugin;
import org.apache.cordova.api.PluginResult;
import org.apache.cordova.file.EncodingException;
import org.apache.cordova.file.FileExistsException;
import org.apache.cordova.file.InvalidModificationException;
import org.apache.cordova.file.NoModificationAllowedException;
import org.apache.cordova.file.TypeMismatchException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileUtils
extends CordovaPlugin {
    private static final String LOG_TAG = "FileUtils";
    public static int NOT_FOUND_ERR = 1;
    public static int SECURITY_ERR = 2;
    public static int ABORT_ERR = 3;
    public static int NOT_READABLE_ERR = 4;
    public static int ENCODING_ERR = 5;
    public static int NO_MODIFICATION_ALLOWED_ERR = 6;
    public static int INVALID_STATE_ERR = 7;
    public static int SYNTAX_ERR = 8;
    public static int INVALID_MODIFICATION_ERR = 9;
    public static int QUOTA_EXCEEDED_ERR = 10;
    public static int TYPE_MISMATCH_ERR = 11;
    public static int PATH_EXISTS_ERR = 12;
    public static int TEMPORARY = 0;
    public static int PERSISTENT = 1;
    public static int RESOURCE = 2;
    public static int APPLICATION = 3;

    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        block37: {
            try {
                if (action.equals("testSaveLocationExists")) {
                    boolean b = DirectoryManager.testSaveLocationExists();
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, b));
                    break block37;
                }
                if (action.equals("getFreeDiskSpace")) {
                    long l = DirectoryManager.getFreeDiskSpace(false);
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, l));
                    break block37;
                }
                if (action.equals("testFileExists")) {
                    boolean b = DirectoryManager.testFileExists(args.getString(0));
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, b));
                    break block37;
                }
                if (action.equals("testDirectoryExists")) {
                    boolean b = DirectoryManager.testFileExists(args.getString(0));
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, b));
                    break block37;
                }
                if (action.equals("readAsText")) {
                    String encoding = args.getString(1);
                    int start = args.getInt(2);
                    int end = args.getInt(3);
                    this.readFileAs(args.getString(0), start, end, callbackContext, encoding, 1);
                    break block37;
                }
                if (action.equals("readAsDataURL")) {
                    int start = args.getInt(1);
                    int end = args.getInt(2);
                    this.readFileAs(args.getString(0), start, end, callbackContext, null, -1);
                    break block37;
                }
                if (action.equals("readAsArrayBuffer")) {
                    int start = args.getInt(1);
                    int end = args.getInt(2);
                    this.readFileAs(args.getString(0), start, end, callbackContext, null, 6);
                    break block37;
                }
                if (action.equals("readAsBinaryString")) {
                    int start = args.getInt(1);
                    int end = args.getInt(2);
                    this.readFileAs(args.getString(0), start, end, callbackContext, null, 7);
                    break block37;
                }
                if (action.equals("write")) {
                    long fileSize = this.write(args.getString(0), args.getString(1), args.getInt(2));
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, fileSize));
                    break block37;
                }
                if (action.equals("truncate")) {
                    long fileSize = this.truncateFile(args.getString(0), args.getLong(1));
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, fileSize));
                    break block37;
                }
                if (action.equals("requestFileSystem")) {
                    long size = args.optLong(1);
                    if (size != 0L && size > DirectoryManager.getFreeDiskSpace(true) * 1024L) {
                        callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, QUOTA_EXCEEDED_ERR));
                    } else {
                        JSONObject obj = this.requestFileSystem(args.getInt(0));
                        callbackContext.success(obj);
                    }
                    break block37;
                }
                if (action.equals("resolveLocalFileSystemURI")) {
                    JSONObject obj = this.resolveLocalFileSystemURI(args.getString(0));
                    callbackContext.success(obj);
                    break block37;
                }
                if (action.equals("getMetadata")) {
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, this.getMetadata(args.getString(0))));
                    break block37;
                }
                if (action.equals("getFileMetadata")) {
                    JSONObject obj = this.getFileMetadata(args.getString(0));
                    callbackContext.success(obj);
                    break block37;
                }
                if (action.equals("getParent")) {
                    JSONObject obj = this.getParent(args.getString(0));
                    callbackContext.success(obj);
                    break block37;
                }
                if (action.equals("getDirectory")) {
                    JSONObject obj = this.getFile(args.getString(0), args.getString(1), args.optJSONObject(2), true);
                    callbackContext.success(obj);
                    break block37;
                }
                if (action.equals("getFile")) {
                    JSONObject obj = this.getFile(args.getString(0), args.getString(1), args.optJSONObject(2), false);
                    callbackContext.success(obj);
                    break block37;
                }
                if (action.equals("remove")) {
                    boolean success = this.remove(args.getString(0));
                    if (success) {
                        this.notifyDelete(args.getString(0));
                        callbackContext.success();
                    } else {
                        callbackContext.error(NO_MODIFICATION_ALLOWED_ERR);
                    }
                    break block37;
                }
                if (action.equals("removeRecursively")) {
                    boolean success = this.removeRecursively(args.getString(0));
                    if (success) {
                        callbackContext.success();
                    } else {
                        callbackContext.error(NO_MODIFICATION_ALLOWED_ERR);
                    }
                    break block37;
                }
                if (action.equals("moveTo")) {
                    JSONObject entry = this.transferTo(args.getString(0), args.getString(1), args.getString(2), true);
                    callbackContext.success(entry);
                    break block37;
                }
                if (action.equals("copyTo")) {
                    JSONObject entry = this.transferTo(args.getString(0), args.getString(1), args.getString(2), false);
                    callbackContext.success(entry);
                    break block37;
                }
                if (action.equals("readEntries")) {
                    JSONArray entries = this.readEntries(args.getString(0));
                    callbackContext.success(entries);
                    break block37;
                }
                return false;
            }
            catch (FileNotFoundException e) {
                callbackContext.error(NOT_FOUND_ERR);
            }
            catch (FileExistsException e) {
                callbackContext.error(PATH_EXISTS_ERR);
            }
            catch (NoModificationAllowedException e) {
                callbackContext.error(NO_MODIFICATION_ALLOWED_ERR);
            }
            catch (InvalidModificationException e) {
                callbackContext.error(INVALID_MODIFICATION_ERR);
            }
            catch (MalformedURLException e) {
                callbackContext.error(ENCODING_ERR);
            }
            catch (IOException e) {
                callbackContext.error(INVALID_MODIFICATION_ERR);
            }
            catch (EncodingException e) {
                callbackContext.error(ENCODING_ERR);
            }
            catch (TypeMismatchException e) {
                callbackContext.error(TYPE_MISMATCH_ERR);
            }
        }
        return true;
    }

    private void notifyDelete(String filePath) {
        String newFilePath = FileHelper.getRealPath(filePath, this.cordova);
        try {
            this.cordova.getActivity().getContentResolver().delete(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, "_data = ?", new String[]{newFilePath});
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private JSONObject resolveLocalFileSystemURI(String url) throws IOException, JSONException {
        String decoded = URLDecoder.decode(url, "UTF-8");
        File fp = null;
        if (decoded.startsWith("content:")) {
            Cursor cursor = this.cordova.getActivity().managedQuery(Uri.parse((String)decoded), new String[]{"_data"}, null, null, null);
            int column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            fp = new File(cursor.getString(column_index));
        } else {
            int questionMark;
            URL testUrl = new URL(decoded);
            fp = decoded.startsWith("file://") ? ((questionMark = decoded.indexOf("?")) < 0 ? new File(decoded.substring(7, decoded.length())) : new File(decoded.substring(7, questionMark))) : new File(decoded);
        }
        if (!fp.exists()) {
            throw new FileNotFoundException();
        }
        if (!fp.canRead()) {
            throw new IOException();
        }
        return FileUtils.getEntry(fp);
    }

    private JSONArray readEntries(String fileName) throws FileNotFoundException, JSONException {
        File fp = this.createFileObject(fileName);
        if (!fp.exists()) {
            throw new FileNotFoundException();
        }
        JSONArray entries = new JSONArray();
        if (fp.isDirectory()) {
            File[] files = fp.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].canRead()) continue;
                entries.put((Object)FileUtils.getEntry(files[i]));
            }
        }
        return entries;
    }

    private JSONObject transferTo(String fileName, String newParent, String newName, boolean move) throws JSONException, NoModificationAllowedException, IOException, InvalidModificationException, EncodingException, FileExistsException {
        String newFileName = FileHelper.getRealPath(fileName, this.cordova);
        newParent = FileHelper.getRealPath(newParent, this.cordova);
        if (newName != null && newName.contains(":")) {
            throw new EncodingException("Bad file name");
        }
        File source = new File(newFileName);
        if (!source.exists()) {
            throw new FileNotFoundException("The source does not exist");
        }
        File destinationDir = new File(newParent);
        if (!destinationDir.exists()) {
            throw new FileNotFoundException("The source does not exist");
        }
        File destination = this.createDestination(newName, source, destinationDir);
        if (source.getAbsolutePath().equals(destination.getAbsolutePath())) {
            throw new InvalidModificationException("Can't copy a file onto itself");
        }
        if (source.isDirectory()) {
            if (move) {
                return this.moveDirectory(source, destination);
            }
            return this.copyDirectory(source, destination);
        }
        if (move) {
            JSONObject newFileEntry = this.moveFile(source, destination);
            if (fileName.startsWith("content://")) {
                this.notifyDelete(fileName);
            }
            return newFileEntry;
        }
        return this.copyFile(source, destination);
    }

    private File createDestination(String newName, File fp, File destination) {
        File destFile = null;
        if ("null".equals(newName) || "".equals(newName)) {
            newName = null;
        }
        destFile = newName != null ? new File(destination.getAbsolutePath() + File.separator + newName) : new File(destination.getAbsolutePath() + File.separator + fp.getName());
        return destFile;
    }

    private JSONObject copyFile(File srcFile, File destFile) throws IOException, InvalidModificationException, JSONException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new InvalidModificationException("Can't rename a file to a directory");
        }
        this.copyAction(srcFile, destFile);
        return FileUtils.getEntry(destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAction(File srcFile, File destFile) throws FileNotFoundException, IOException {
        FileInputStream istream = new FileInputStream(srcFile);
        FileOutputStream ostream = new FileOutputStream(destFile);
        FileChannel input = istream.getChannel();
        FileChannel output = ostream.getChannel();
        try {
            input.transferTo(0L, input.size(), output);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            istream.close();
            ostream.close();
            input.close();
            output.close();
            throw throwable;
        }
        istream.close();
        ostream.close();
        input.close();
        output.close();
    }

    private JSONObject copyDirectory(File srcDir, File destinationDir) throws JSONException, IOException, NoModificationAllowedException, InvalidModificationException {
        if (destinationDir.exists() && destinationDir.isFile()) {
            throw new InvalidModificationException("Can't rename a file to a directory");
        }
        if (this.isCopyOnItself(srcDir.getAbsolutePath(), destinationDir.getAbsolutePath())) {
            throw new InvalidModificationException("Can't copy itself into itself");
        }
        if (!destinationDir.exists() && !destinationDir.mkdir()) {
            throw new NoModificationAllowedException("Couldn't create the destination directory");
        }
        for (File file : srcDir.listFiles()) {
            if (file.isDirectory()) {
                this.copyDirectory(file, destinationDir);
                continue;
            }
            File destination = new File(destinationDir.getAbsoluteFile() + File.separator + file.getName());
            this.copyFile(file, destination);
        }
        return FileUtils.getEntry(destinationDir);
    }

    private boolean isCopyOnItself(String src, String dest) {
        return dest.startsWith(src) && dest.indexOf(File.separator, src.length() - 1) != -1;
    }

    private JSONObject moveFile(File srcFile, File destFile) throws IOException, JSONException, InvalidModificationException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new InvalidModificationException("Can't rename a file to a directory");
        }
        if (!srcFile.renameTo(destFile)) {
            this.copyAction(srcFile, destFile);
            if (destFile.exists()) {
                srcFile.delete();
            } else {
                throw new IOException("moved failed");
            }
        }
        return FileUtils.getEntry(destFile);
    }

    private JSONObject moveDirectory(File srcDir, File destinationDir) throws IOException, JSONException, InvalidModificationException, NoModificationAllowedException, FileExistsException {
        if (destinationDir.exists() && destinationDir.isFile()) {
            throw new InvalidModificationException("Can't rename a file to a directory");
        }
        if (this.isCopyOnItself(srcDir.getAbsolutePath(), destinationDir.getAbsolutePath())) {
            throw new InvalidModificationException("Can't move itself into itself");
        }
        if (destinationDir.exists() && destinationDir.list().length > 0) {
            throw new InvalidModificationException("directory is not empty");
        }
        if (!srcDir.renameTo(destinationDir)) {
            this.copyDirectory(srcDir, destinationDir);
            if (destinationDir.exists()) {
                this.removeDirRecursively(srcDir);
            } else {
                throw new IOException("moved failed");
            }
        }
        return FileUtils.getEntry(destinationDir);
    }

    private boolean removeRecursively(String filePath) throws FileExistsException {
        File fp = this.createFileObject(filePath);
        if (this.atRootDirectory(filePath)) {
            return false;
        }
        return this.removeDirRecursively(fp);
    }

    private boolean removeDirRecursively(File directory) throws FileExistsException {
        if (directory.isDirectory()) {
            for (File file : directory.listFiles()) {
                this.removeDirRecursively(file);
            }
        }
        if (!directory.delete()) {
            throw new FileExistsException("could not delete: " + directory.getName());
        }
        return true;
    }

    private boolean remove(String filePath) throws NoModificationAllowedException, InvalidModificationException {
        File fp = this.createFileObject(filePath);
        if (this.atRootDirectory(filePath)) {
            throw new NoModificationAllowedException("You can't delete the root directory");
        }
        if (fp.isDirectory() && fp.list().length > 0) {
            throw new InvalidModificationException("You can't delete a directory that is not empty.");
        }
        return fp.delete();
    }

    private JSONObject getFile(String dirPath, String fileName, JSONObject options, boolean directory) throws FileExistsException, IOException, TypeMismatchException, EncodingException, JSONException {
        boolean create = false;
        boolean exclusive = false;
        if (options != null && (create = options.optBoolean("create"))) {
            exclusive = options.optBoolean("exclusive");
        }
        if (fileName.contains(":")) {
            throw new EncodingException("This file has a : in it's name");
        }
        File fp = this.createFileObject(dirPath, fileName);
        if (create) {
            if (exclusive && fp.exists()) {
                throw new FileExistsException("create/exclusive fails");
            }
            if (directory) {
                fp.mkdir();
            } else {
                fp.createNewFile();
            }
            if (!fp.exists()) {
                throw new FileExistsException("create fails");
            }
        } else {
            if (!fp.exists()) {
                throw new FileNotFoundException("path does not exist");
            }
            if (directory) {
                if (fp.isFile()) {
                    throw new TypeMismatchException("path doesn't exist or is file");
                }
            } else if (fp.isDirectory()) {
                throw new TypeMismatchException("path doesn't exist or is directory");
            }
        }
        return FileUtils.getEntry(fp);
    }

    private File createFileObject(String dirPath, String fileName) {
        File fp = null;
        if (fileName.startsWith("/")) {
            fp = new File(fileName);
        } else {
            dirPath = FileHelper.getRealPath(dirPath, this.cordova);
            fp = new File(dirPath + File.separator + fileName);
        }
        return fp;
    }

    private JSONObject getParent(String filePath) throws JSONException {
        if (this.atRootDirectory(filePath = FileHelper.getRealPath(filePath, this.cordova))) {
            return this.getEntry(filePath);
        }
        return this.getEntry(new File(filePath).getParent());
    }

    private boolean atRootDirectory(String filePath) {
        return (filePath = FileHelper.getRealPath(filePath, this.cordova)).equals(Environment.getExternalStorageDirectory().getAbsolutePath() + "/Android/data/" + this.cordova.getActivity().getPackageName() + "/cache") || filePath.equals(Environment.getExternalStorageDirectory().getAbsolutePath()) || filePath.equals("/data/data/" + this.cordova.getActivity().getPackageName());
    }

    private File createFileObject(String filePath) {
        filePath = FileHelper.getRealPath(filePath, this.cordova);
        File file = new File(filePath);
        return file;
    }

    private long getMetadata(String filePath) throws FileNotFoundException {
        File file = this.createFileObject(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException("Failed to find file in getMetadata");
        }
        return file.lastModified();
    }

    private JSONObject getFileMetadata(String filePath) throws FileNotFoundException, JSONException {
        File file = this.createFileObject(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException("File: " + filePath + " does not exist.");
        }
        JSONObject metadata = new JSONObject();
        metadata.put("size", file.length());
        metadata.put("type", (Object)FileHelper.getMimeType(filePath, this.cordova));
        metadata.put("name", (Object)file.getName());
        metadata.put("fullPath", (Object)filePath);
        metadata.put("lastModifiedDate", file.lastModified());
        return metadata;
    }

    private JSONObject requestFileSystem(int type) throws IOException, JSONException {
        JSONObject fs = new JSONObject();
        if (type == TEMPORARY) {
            fs.put("name", (Object)"temporary");
            if (Environment.getExternalStorageState().equals("mounted")) {
                File fp = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + "/Android/data/" + this.cordova.getActivity().getPackageName() + "/cache/");
                fp.mkdirs();
                fs.put("root", (Object)this.getEntry(Environment.getExternalStorageDirectory().getAbsolutePath() + "/Android/data/" + this.cordova.getActivity().getPackageName() + "/cache/"));
            } else {
                File fp = new File("/data/data/" + this.cordova.getActivity().getPackageName() + "/cache/");
                fp.mkdirs();
                fs.put("root", (Object)this.getEntry("/data/data/" + this.cordova.getActivity().getPackageName() + "/cache/"));
            }
        } else if (type == PERSISTENT) {
            fs.put("name", (Object)"persistent");
            if (Environment.getExternalStorageState().equals("mounted")) {
                fs.put("root", (Object)FileUtils.getEntry(Environment.getExternalStorageDirectory()));
            } else {
                fs.put("root", (Object)this.getEntry("/data/data/" + this.cordova.getActivity().getPackageName()));
            }
        } else {
            throw new IOException("No filesystem of type requested");
        }
        return fs;
    }

    public static JSONObject getEntry(File file) throws JSONException {
        JSONObject entry = new JSONObject();
        entry.put("isFile", file.isFile());
        entry.put("isDirectory", file.isDirectory());
        entry.put("name", (Object)file.getName());
        entry.put("fullPath", (Object)("file://" + file.getAbsolutePath()));
        return entry;
    }

    private JSONObject getEntry(String path) throws JSONException {
        return FileUtils.getEntry(new File(path));
    }

    public void readFileAs(final String filename, final int start, final int end, final CallbackContext callbackContext, final String encoding, final int resultType) {
        this.cordova.getThreadPool().execute(new Runnable(){

            public void run() {
                try {
                    PluginResult result;
                    byte[] bytes = FileUtils.this.readAsBinaryHelper(filename, start, end);
                    switch (resultType) {
                        case 1: {
                            result = new PluginResult(PluginResult.Status.OK, new String(bytes, encoding));
                            break;
                        }
                        case 6: {
                            result = new PluginResult(PluginResult.Status.OK, bytes);
                            break;
                        }
                        case 7: {
                            result = new PluginResult(PluginResult.Status.OK, bytes, true);
                            break;
                        }
                        default: {
                            String contentType = FileHelper.getMimeType(filename, FileUtils.this.cordova);
                            byte[] base64 = Base64.encodeBase64((byte[])bytes);
                            String s = "data:" + contentType + ";base64," + new String(base64, "US-ASCII");
                            result = new PluginResult(PluginResult.Status.OK, s);
                        }
                    }
                    callbackContext.sendPluginResult(result);
                }
                catch (FileNotFoundException e) {
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, NOT_FOUND_ERR));
                }
                catch (IOException e) {
                    Log.d((String)FileUtils.LOG_TAG, (String)e.getLocalizedMessage());
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, NOT_READABLE_ERR));
                }
            }
        });
    }

    private byte[] readAsBinaryHelper(String filename, int start, int end) throws IOException {
        int numBytesToRead = end - start;
        byte[] bytes = new byte[numBytesToRead];
        InputStream inputStream = FileHelper.getInputStreamFromUriString(filename, this.cordova);
        int numBytesRead = 0;
        if (start > 0) {
            inputStream.skip(start);
        }
        while (numBytesToRead > 0 && (numBytesRead = inputStream.read(bytes, numBytesRead, numBytesToRead)) >= 0) {
            numBytesToRead -= numBytesRead;
        }
        return bytes;
    }

    public long write(String filename, String data, int offset) throws FileNotFoundException, IOException, NoModificationAllowedException {
        if (filename.startsWith("content://")) {
            throw new NoModificationAllowedException("Couldn't write to file given its content URI");
        }
        filename = FileHelper.getRealPath(filename, this.cordova);
        boolean append = false;
        if (offset > 0) {
            this.truncateFile(filename, offset);
            append = true;
        }
        byte[] rawData = data.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(rawData);
        FileOutputStream out = new FileOutputStream(filename, append);
        byte[] buff = new byte[rawData.length];
        in.read(buff, 0, buff.length);
        out.write(buff, 0, rawData.length);
        out.flush();
        out.close();
        return rawData.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long truncateFile(String filename, long size) throws FileNotFoundException, IOException, NoModificationAllowedException {
        RandomAccessFile raf;
        block4: {
            long l;
            if (filename.startsWith("content://")) {
                throw new NoModificationAllowedException("Couldn't truncate file given its content URI");
            }
            filename = FileHelper.getRealPath(filename, this.cordova);
            raf = new RandomAccessFile(filename, "rw");
            try {
                if (raf.length() < size) break block4;
                FileChannel channel = raf.getChannel();
                channel.truncate(size);
                l = size;
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                raf.close();
                throw throwable;
            }
            raf.close();
            return l;
        }
        long l = raf.length();
        Object var9_8 = null;
        raf.close();
        return l;
    }
}

