/*
 * Copyright (C) 2015 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.errai.ui.shared.wrapper;

import com.google.gwt.dom.client.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Read only wrapper to transform a gwt dom nodeList to w3c one.
 * @author edewit@redhat.com
 */
public class NodeListWrapper implements NodeList {
  private final com.google.gwt.dom.client.NodeList<com.google.gwt.dom.client.Node> nodeList;

  public NodeListWrapper(com.google.gwt.dom.client.NodeList<com.google.gwt.dom.client.Node> nodeList) {
    this.nodeList = nodeList;
  }

  public Node item(int index) {
    final com.google.gwt.dom.client.Node node = nodeList.getItem(index);
    if (node instanceof Element) {
      return new ElementWrapper((Element) node);
    }
    return new NodeWrapper(node);
  }

  @Override
  public int getLength() {
    return nodeList.getLength();
  }
}
