/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa;

import org.jboss.forge.addon.javaee.jpa.DatabaseType;
import org.jboss.forge.addon.javaee.jpa.PersistenceContainer;
import org.jboss.forge.addon.javaee.jpa.PersistenceProvider;
import org.jboss.forge.addon.javaee.jpa.SchemaGenerationType;
import org.jboss.forge.furnace.util.Strings;

public class JPADataSource {
    private String jdbcDriver;
    private String databaseURL;
    private String username;
    private String password;
    private DatabaseType database;
    private String jndiDataSource;
    private PersistenceContainer container;
    private PersistenceProvider provider;
    private SchemaGenerationType schemaGenerationType = SchemaGenerationType.DROP_CREATE;

    public DatabaseType getDatabase() {
        return this.database == null ? DatabaseType.DEFAULT : this.database;
    }

    public String getJndiDataSource() {
        return this.jndiDataSource;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getDatabaseURL() {
        return this.databaseURL;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public JPADataSource setDatabase(DatabaseType database) {
        this.database = database;
        return this;
    }

    public JPADataSource setJndiDataSource(String jtaDataSource) {
        this.jndiDataSource = jtaDataSource;
        return this;
    }

    public JPADataSource setDatabaseType(DatabaseType databaseType) {
        this.database = databaseType;
        return this;
    }

    public JPADataSource setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
        return this;
    }

    public JPADataSource setDatabaseURL(String databaseURL) {
        this.databaseURL = databaseURL;
        return this;
    }

    public JPADataSource setUsername(String username) {
        this.username = username;
        return this;
    }

    public JPADataSource setPassword(String password) {
        this.password = password;
        return this;
    }

    public boolean hasNonDefaultDatabase() {
        return !DatabaseType.DEFAULT.equals((Object)this.getDatabase());
    }

    public boolean hasJdbcConnectionInfo() {
        return !Strings.isNullOrEmpty((String)this.databaseURL) || !Strings.isNullOrEmpty((String)this.jdbcDriver) || !Strings.isNullOrEmpty((String)this.username) || !Strings.isNullOrEmpty((String)this.password);
    }

    public String getJdbcConnectionInfo() {
        String result = this.jdbcDriver == null ? "" : this.jdbcDriver;
        result = result + (this.databaseURL == null ? "" : ", " + this.databaseURL);
        result = result + (this.username == null ? "" : ", " + this.username);
        result = result + (this.password == null ? "" : ", " + this.password);
        return result;
    }

    public JPADataSource setContainer(PersistenceContainer container) {
        this.container = container;
        return this;
    }

    public PersistenceContainer getContainer() {
        return this.container;
    }

    public JPADataSource setProvider(PersistenceProvider provider) {
        this.provider = provider;
        return this;
    }

    public JPADataSource setSchemaGenerationType(SchemaGenerationType schemaGenerationType) {
        this.schemaGenerationType = schemaGenerationType;
        return this;
    }

    public PersistenceProvider getProvider() {
        return this.provider;
    }

    public SchemaGenerationType getSchemaGenerationType() {
        return this.schemaGenerationType;
    }

    public void validate() throws Exception {
        this.getContainer().validate(this);
        this.getProvider().validate(this);
    }
}

