/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.rest.config;

import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.jboss.forge.addon.javaee.rest.config.RestConfigurationStrategy;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;

public class RestApplicationClassConfigurationStrategy
implements RestConfigurationStrategy {
    private final String path;
    private final JavaClassSource applicationClass;

    public RestApplicationClassConfigurationStrategy(JavaClassSource javaClass) {
        Assert.notNull((Object)javaClass, (String)"JavaClass cannot be null");
        Assert.isTrue((boolean)javaClass.hasAnnotation(ApplicationPath.class), (String)"@ApplicationPath should be present in the JavaClass");
        this.applicationClass = javaClass;
        this.path = javaClass.getAnnotation(ApplicationPath.class).getStringValue();
    }

    public RestApplicationClassConfigurationStrategy(String path, JavaClassSource javaClass) {
        Assert.notNull((Object)path, (String)"Path cannot be null");
        Assert.notNull((Object)javaClass, (String)"JavaClass cannot be null");
        this.applicationClass = javaClass;
        this.path = path;
    }

    @Override
    public String getApplicationPath() {
        return this.path;
    }

    public JavaClassSource getResource() {
        return this.applicationClass;
    }

    @Override
    public void install(Project project) {
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        this.applicationClass.setSuperType(Application.class);
        if (this.applicationClass.hasAnnotation(ApplicationPath.class)) {
            this.applicationClass.getAnnotation(ApplicationPath.class).setStringValue(this.path);
        } else {
            this.applicationClass.addAnnotation(ApplicationPath.class).setStringValue(this.path);
        }
        facet.saveJavaSource((JavaSource)this.applicationClass);
    }

    @Override
    public void uninstall(Project project) {
    }
}

