/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.rest.config;

import java.io.FileNotFoundException;
import javax.ws.rs.ApplicationPath;
import org.jboss.forge.addon.javaee.rest.config.RestApplicationClassConfigurationStrategy;
import org.jboss.forge.addon.javaee.rest.config.RestConfigurationStrategy;
import org.jboss.forge.addon.javaee.rest.config.RestWebXmlConfigurationStrategy;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;

public class RestConfigurationStrategyFactory {
    public static RestConfigurationStrategy from(Project project) {
        String path;
        final RestConfigurationStrategy[] configurationStrategy = new RestConfigurationStrategy[1];
        if (project.hasFacet(JavaSourceFacet.class)) {
            JavaSourceFacet javaSourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
            javaSourceFacet.visitJavaSources(new JavaResourceVisitor(){

                public void visit(VisitContext context, JavaResource javaResource) {
                    try {
                        JavaSource javaSource = (JavaSource)javaResource.getJavaType();
                        if (javaSource.hasAnnotation(ApplicationPath.class) && javaSource.isClass()) {
                            configurationStrategy[0] = RestConfigurationStrategyFactory.createUsingJavaClass((JavaClassSource)javaSource);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
            });
        }
        if (configurationStrategy[0] == null && (path = RestWebXmlConfigurationStrategy.getServletPath(project)) != null) {
            configurationStrategy[0] = RestConfigurationStrategyFactory.createUsingWebXml(path);
        }
        return configurationStrategy[0];
    }

    public static RestConfigurationStrategy createUsingWebXml(String path) {
        return new RestWebXmlConfigurationStrategy(path);
    }

    public static RestConfigurationStrategy createUsingJavaClass(String path, JavaClassSource javaClass) {
        return new RestApplicationClassConfigurationStrategy(path, javaClass);
    }

    public static RestConfigurationStrategy createUsingJavaClass(JavaClassSource javaClass) {
        return new RestApplicationClassConfigurationStrategy(javaClass);
    }
}

