/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.rest.config;

import java.util.Iterator;
import java.util.List;
import org.jboss.forge.addon.javaee.rest.config.RestConfigurationStrategy;
import org.jboss.forge.addon.javaee.servlet.ServletFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.shrinkwrap.descriptor.api.webapp.WebAppCommonDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webcommon.ServletMappingCommonType;

public class RestWebXmlConfigurationStrategy
implements RestConfigurationStrategy {
    public static final String JAXRS_SERVLET = "javax.ws.rs.core.Application";
    private final String path;

    public RestWebXmlConfigurationStrategy(String path) {
        Assert.notNull((Object)path, (String)"Path cannot be null");
        this.path = path;
    }

    @Override
    public String getApplicationPath() {
        return this.path;
    }

    @Override
    public void install(Project project) {
        if (!this.installedInWebXML(project)) {
            ServletFacet servlet = (ServletFacet)project.getFacet(ServletFacet.class);
            WebAppCommonDescriptor config = (WebAppCommonDescriptor)servlet.getConfig();
            config.createServlet().servletName(JAXRS_SERVLET).loadOnStartup(Integer.valueOf(1));
            String urlPattern = this.path;
            if (urlPattern.endsWith("/")) {
                urlPattern = urlPattern.substring(0, urlPattern.length() - 1);
            }
            config.createServletMapping().servletName(JAXRS_SERVLET).urlPattern(new String[]{urlPattern});
            servlet.saveConfig(config);
        }
    }

    private boolean installedInWebXML(Project project) {
        return RestWebXmlConfigurationStrategy.getServletPath(project) != null;
    }

    static String getServletPath(Project project) {
        String servletPath = null;
        if (project.hasFacet(ServletFacet.class)) {
            ServletFacet servlet = (ServletFacet)project.getFacet(ServletFacet.class);
            WebAppCommonDescriptor config = (WebAppCommonDescriptor)servlet.getConfig();
            List allServletMapping = config.getAllServletMapping();
            for (ServletMappingCommonType servletMappingType : allServletMapping) {
                if (!JAXRS_SERVLET.equals(servletMappingType.getServletName())) continue;
                List allUrlPattern = servletMappingType.getAllUrlPattern();
                Iterator iterator = allUrlPattern.iterator();
                while (iterator.hasNext()) {
                    String urlPattern;
                    servletPath = urlPattern = (String)iterator.next();
                }
            }
        }
        return servletPath;
    }

    @Override
    public void uninstall(Project project) {
    }
}

