/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.scaffold.faces.freemarker;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class FreemarkerTemplateProcessor {
    private static Configuration freemarkerConfig;

    public static Template getTemplate(String templateLocation) {
        try {
            Template templateFile = FreemarkerTemplateProcessor.getFreemarkerConfig().getTemplate(templateLocation);
            return templateFile;
        }
        catch (IOException ioEx) {
            throw new RuntimeException(ioEx);
        }
    }

    public static String processTemplate(Map<Object, Object> map, String templateLocation) {
        StringWriter output = new StringWriter();
        try {
            Template templateFile = FreemarkerTemplateProcessor.getFreemarkerConfig().getTemplate(templateLocation);
            templateFile.process(map, (Writer)output);
            ((Writer)output).flush();
        }
        catch (IOException ioEx) {
            throw new RuntimeException(ioEx);
        }
        catch (TemplateException templateEx) {
            throw new RuntimeException(templateEx);
        }
        return ((Object)output).toString();
    }

    public static String processTemplate(Map<Object, Object> map, Template template) {
        StringWriter output = new StringWriter();
        try {
            template.process(map, (Writer)output);
            ((Writer)output).flush();
        }
        catch (IOException ioEx) {
            throw new RuntimeException(ioEx);
        }
        catch (TemplateException templateEx) {
            throw new RuntimeException(templateEx);
        }
        return ((Object)output).toString();
    }

    private static Configuration getFreemarkerConfig() {
        if (freemarkerConfig == null) {
            freemarkerConfig = new Configuration();
            freemarkerConfig.setClassForTemplateLoading(FreemarkerTemplateProcessor.class, "/");
            freemarkerConfig.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        }
        return freemarkerConfig;
    }
}

