/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.bootstrap;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.impl.addons.AddonRepositoryImpl;
import org.jboss.forge.furnace.manager.impl.AddonManagerImpl;
import org.jboss.forge.furnace.manager.maven.addon.MavenAddonDependencyResolver;
import org.jboss.forge.furnace.manager.request.InstallRequest;
import org.jboss.forge.furnace.manager.request.RemoveRequest;
import org.jboss.forge.furnace.manager.spi.AddonDependencyResolver;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.AddonRepositoryMode;
import org.jboss.forge.furnace.repositories.MutableAddonRepository;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.furnace.versions.Versions;

public class Bootstrap {
    private static final String FORGE_ADDON_GROUP_ID = "org.jboss.forge.addon:";
    private final Furnace furnace;
    private boolean exitAfter = false;
    private boolean batchMode = false;

    public static void main(String[] args) throws InterruptedException, ExecutionException {
        ArrayList<String> bootstrapArgs = new ArrayList<String>();
        Properties systemProperties = System.getProperties();
        for (String arg : args) {
            if (arg.startsWith("-D")) {
                String value;
                String name;
                int index = arg.indexOf("=");
                if (index == -1) {
                    name = arg.substring(2);
                    value = "true";
                } else {
                    name = arg.substring(2, index);
                    value = arg.substring(index + 1);
                }
                systemProperties.setProperty(name, value);
                continue;
            }
            bootstrapArgs.add(arg);
        }
        String logDir = systemProperties.getProperty("org.jboss.forge.log.file", new File(OperatingSystemUtils.getUserForgeDir(), "log/forge.log").getAbsolutePath());
        systemProperties.setProperty("org.jboss.forge.log.file", logDir);
        String logManagerName = Bootstrap.getServiceName(Bootstrap.class.getClassLoader(), "java.util.logging.LogManager");
        if (logManagerName != null) {
            systemProperties.setProperty("java.util.logging.manager", logManagerName);
        }
        Bootstrap bootstrap = new Bootstrap(bootstrapArgs.toArray(new String[bootstrapArgs.size()]));
        bootstrap.start();
    }

    private Bootstrap(String[] args) {
        boolean listInstalled = false;
        String installAddon = null;
        String removeAddon = null;
        this.furnace = ServiceLoader.load(Furnace.class).iterator().next();
        this.furnace.setArgs(args);
        if (args.length > 0) {
            List<String> listArgs = Arrays.asList(args);
            if (listArgs.contains("--help") || listArgs.contains("-h")) {
                System.out.println(this.help());
                this.exitAfter = true;
                return;
            }
            for (int i = 0; i < args.length; ++i) {
                if ("--install".equals(args[i]) || "-i".equals(args[i])) {
                    installAddon = args[++i];
                    continue;
                }
                if ("--remove".equals(args[i]) || "-r".equals(args[i])) {
                    removeAddon = args[++i];
                    continue;
                }
                if ("--list".equals(args[i]) || "-l".equals(args[i])) {
                    listInstalled = true;
                    continue;
                }
                if ("--addonDir".equals(args[i]) || "-a".equals(args[i])) {
                    this.furnace.addRepository(AddonRepositoryMode.MUTABLE, new File(args[++i]));
                    continue;
                }
                if ("--immutableAddonDir".equals(args[i]) || "-m".equals(args[i])) {
                    this.furnace.addRepository(AddonRepositoryMode.IMMUTABLE, new File(args[++i]));
                    continue;
                }
                if ("--batchMode".equals(args[i]) || "-b".equals(args[i])) {
                    this.batchMode = true;
                    this.furnace.setServerMode(false);
                    continue;
                }
                if ("--evaluate".equals(args[i]) || "-e".equals(args[i])) {
                    this.furnace.setServerMode(true);
                    System.setProperty("INTERACTIVE", "false");
                    System.setProperty("forge.shell.evaluate", "true");
                    ++i;
                    continue;
                }
                if ("--debug".equals(args[i]) || "-d".equals(args[i])) continue;
                if ("--version".equals(args[i]) || "-v".equals(args[i])) {
                    System.out.println("Forge version " + AddonRepositoryImpl.getRuntimeAPIVersion());
                    this.exitAfter = true;
                    continue;
                }
                System.out.println("forge: unrecognized option: '" + args[i] + "'");
                System.out.println("Try 'forge --help' for more information.");
                this.exitAfter = true;
            }
        }
        if (!this.containsMutableRepository(this.furnace.getRepositories())) {
            this.furnace.addRepository(AddonRepositoryMode.MUTABLE, new File(OperatingSystemUtils.getUserForgeDir(), "addons"));
        }
        if (listInstalled) {
            this.list();
        }
        if (installAddon != null) {
            this.install(installAddon);
        }
        if (removeAddon != null) {
            this.remove(removeAddon);
        }
    }

    private String help() {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage: forge [OPTION]... PARAMETER ... \n");
        sb.append("The fastest way to build applications, share your software, and enjoy doing it. \n");
        sb.append("\n");
        sb.append("-i, --install [[groupId:]addon[,version]]\n");
        sb.append("\t install the required addons and exit. ex: `forge -i core-addon-x` or `forge -i org.example.addon:example,1.0.0` \n");
        sb.append("-r, --remove [[groupId:]addon[,version]]\n");
        sb.append("\t remove the required addons and exit. ex: `forge -r core-addon-x` or `forge -r org.example.addon:example,1.0.0` \n");
        sb.append("-l, --list\n");
        sb.append("\t list installed addons and exit \n");
        sb.append("-a, --addonDir [dir]\n");
        sb.append("\t add the given directory for use as a custom addon repository \n");
        sb.append("-e, --evaluate [cmd]\n");
        sb.append("\t evaluate the given string as commands (requires shell addon. Install via: `forge -i shell`) \n");
        sb.append("-m, --immutableAddonDir [dir]\n");
        sb.append("\t add the given directory for use as a custom immutable addon repository (read only) \n");
        sb.append("-b, --batchMode\n");
        sb.append("\t run Forge in batch mode and does not prompt for confirmation (exits immediately after running) \n");
        sb.append("-d, --debug\n");
        sb.append("\t run Forge in debug mode (wait on port 8000 for a debugger to attach) \n");
        sb.append("-h, --help\n");
        sb.append("\t display this help and exit \n");
        sb.append("-v, --version\n");
        sb.append("\t output version information and exit \n");
        return sb.toString();
    }

    private boolean containsMutableRepository(List<AddonRepository> repositories) {
        boolean result = false;
        for (AddonRepository repository : repositories) {
            if (!(repository instanceof MutableAddonRepository)) continue;
            result = true;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void list() {
        try {
            for (AddonRepository repository : this.furnace.getRepositories()) {
                System.out.println(repository.getRootDirectory().getCanonicalPath() + ":");
                List addons = repository.listAll();
                for (AddonId addon : addons) {
                    System.out.println(addon.toCoordinates());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("> Forge version [" + AddonRepositoryImpl.getRuntimeAPIVersion() + "]");
        }
        finally {
            this.exitAfter = true;
        }
    }

    private List<AddonId> getEnabledAddonIds() {
        ArrayList<AddonId> result = new ArrayList<AddonId>();
        for (AddonRepository repository : this.furnace.getRepositories()) {
            List addons = repository.listEnabled();
            result.addAll(addons);
        }
        return result;
    }

    private void start() throws InterruptedException, ExecutionException {
        if (!this.exitAfter) {
            String result;
            List<AddonId> addonIds;
            if (!this.batchMode && (addonIds = this.getEnabledAddonIds()).isEmpty() && !"n".equalsIgnoreCase((result = System.console().readLine("There are no addons installed/enabled; install core addons now? [Y,n] ", new Object[0])).trim())) {
                this.install("core");
            }
            this.furnace.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install(String addonCoordinates) {
        Version runtimeAPIVersion = AddonRepositoryImpl.getRuntimeAPIVersion();
        try {
            String result;
            AddonId addon;
            MavenAddonDependencyResolver resolver = new MavenAddonDependencyResolver();
            AddonManagerImpl addonManager = new AddonManagerImpl(this.furnace, (AddonDependencyResolver)resolver);
            if (addonCoordinates.contains(",")) {
                addon = addonCoordinates.contains(":") ? AddonId.fromCoordinates((String)addonCoordinates) : AddonId.fromCoordinates((String)(FORGE_ADDON_GROUP_ID + addonCoordinates));
            } else {
                AddonId[] versions;
                String coordinate;
                if (addonCoordinates.contains(":")) {
                    coordinate = addonCoordinates;
                    versions = (AddonId[])resolver.resolveVersions(addonCoordinates).get();
                } else {
                    coordinate = FORGE_ADDON_GROUP_ID + addonCoordinates;
                    versions = (AddonId[])resolver.resolveVersions(coordinate).get();
                }
                if (versions.length == 0) {
                    throw new IllegalArgumentException("No Artifact version found for " + coordinate);
                }
                AddonId selected = null;
                for (int i = versions.length - 1; selected == null && i >= 0; --i) {
                    String apiVersion = (String)resolver.resolveAPIVersion(versions[i]).get();
                    if (apiVersion == null || !Versions.isApiCompatible((Version)runtimeAPIVersion, (Version)new SingleVersion(apiVersion))) continue;
                    selected = versions[i];
                }
                if (selected == null) {
                    throw new IllegalArgumentException("No compatible addon API version found for " + coordinate + " for API " + runtimeAPIVersion);
                }
                addon = selected;
            }
            InstallRequest request = addonManager.install(addon);
            System.out.println(request);
            if (!this.batchMode && "n".equalsIgnoreCase((result = System.console().readLine("Confirm installation [Y/n]? ", new Object[0])).trim())) {
                System.out.println("Installation aborted.");
                return;
            }
            request.perform();
            System.out.println("Installation completed successfully.");
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("> Forge version [" + runtimeAPIVersion + "]");
        }
        finally {
            this.exitAfter = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(String addonCoordinates) {
        try {
            String coordinates;
            MavenAddonDependencyResolver resolver = new MavenAddonDependencyResolver();
            AddonManagerImpl addonManager = new AddonManagerImpl(this.furnace, (AddonDependencyResolver)resolver);
            AddonId addon = null;
            if (addonCoordinates.contains(",")) {
                addon = addonCoordinates.contains(":") ? AddonId.fromCoordinates((String)addonCoordinates) : AddonId.fromCoordinates((String)(FORGE_ADDON_GROUP_ID + addonCoordinates));
                coordinates = addon.getName();
            } else {
                coordinates = addonCoordinates.contains(":") ? addonCoordinates : FORGE_ADDON_GROUP_ID + addonCoordinates;
            }
            block6: for (AddonRepository repository : this.furnace.getRepositories()) {
                for (AddonId id : repository.listAll()) {
                    String result;
                    if (!coordinates.equals(id.getName())) continue;
                    addon = id;
                    if (!(repository instanceof MutableAddonRepository)) break block6;
                    RemoveRequest request = addonManager.remove(id, repository);
                    System.out.println(request);
                    if (!this.batchMode && "n".equalsIgnoreCase((result = System.console().readLine("Confirm uninstallation [Y/n]? ", new Object[0])).trim())) {
                        System.out.println("Uninstallation aborted.");
                        return;
                    }
                    request.perform();
                    System.out.println("Uninstallation completed successfully.");
                    System.out.println();
                    break block6;
                }
            }
            if (addon == null) {
                throw new IllegalArgumentException("No addon exists with id " + coordinates);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("> Forge version [" + AddonRepositoryImpl.getRuntimeAPIVersion() + "]");
        }
        finally {
            this.exitAfter = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getServiceName(ClassLoader classLoader, String className) {
        try (InputStream stream = classLoader.getResourceAsStream("META-INF/services/" + className);){
            Throwable throwable;
            BufferedReader reader;
            block36: {
                if (stream == null) return null;
                try {
                    String string;
                    block34: {
                        block35: {
                            reader = new BufferedReader(new InputStreamReader(stream));
                            throwable = null;
                            try {
                                String line;
                                while ((line = reader.readLine()) != null) {
                                    int i = line.indexOf(35);
                                    if (i != -1) {
                                        line = line.substring(0, i);
                                    }
                                    if ((line = line.trim()).length() == 0) continue;
                                    string = line;
                                    if (reader == null) return string;
                                    if (throwable == null) break block34;
                                    break block35;
                                }
                                break block36;
                            }
                            catch (Throwable throwable2) {
                                try {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (reader == null) throw throwable3;
                                    if (throwable != null) {
                                        try {
                                            reader.close();
                                            throw throwable3;
                                        }
                                        catch (Throwable throwable4) {
                                            throwable.addSuppressed(throwable4);
                                            throw throwable3;
                                        }
                                    }
                                    reader.close();
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            reader.close();
                            return string;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            return string;
                        }
                    }
                    reader.close();
                    return string;
                }
                catch (IOException iOException) {
                    // empty catch block
                    return null;
                }
            }
            if (reader == null) return null;
            if (throwable == null) {
                reader.close();
                return null;
            }
            try {
                reader.close();
                return null;
            }
            catch (Throwable throwable6) {
                throwable.addSuppressed(throwable6);
                return null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

