/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.dev;

import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.DependencyInstaller;
import org.jboss.forge.project.dependencies.ScopeType;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.project.facets.PackagingFacet;
import org.jboss.forge.project.facets.ResourceFacet;
import org.jboss.forge.project.packaging.PackagingType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresPackagingType;
import org.jboss.forge.spec.javaee.CDIFacet;

@Alias(value="forge.api")
@RequiresFacet(value={DependencyFacet.class, PackagingFacet.class, CDIFacet.class, ResourceFacet.class})
@RequiresPackagingType(value={PackagingType.JAR})
public class ForgeAPIFacet
extends BaseFacet {
    @Inject
    private Shell shell;
    @Inject
    private DependencyInstaller installer;

    public boolean install() {
        DependencyFacet deps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        List versions = deps.resolveAvailableVersions("org.jboss.forge:forge-shell-api:[,]");
        Dependency version = (Dependency)this.shell.promptChoiceTyped("Install which version of the Forge API?", versions, versions.get(versions.size() - 1));
        deps.setProperty("forge.api.version", version.getVersion());
        DependencyBuilder apiDep = DependencyBuilder.create((String)"org.jboss.forge:forge-shell-api:${forge.api.version}").setScopeType(ScopeType.PROVIDED);
        DependencyBuilder testDep = DependencyBuilder.create((String)"org.jboss.forge:forge-test-harness:${forge.api.version}").setScopeType(ScopeType.TEST);
        DependencyBuilder testShellDep = DependencyBuilder.create((String)"org.jboss.forge:forge-shell:${forge.api.version}").setScopeType(ScopeType.TEST);
        this.installer.install(this.project, (Dependency)apiDep);
        this.installer.install(this.project, (Dependency)testDep);
        this.installer.install(this.project, (Dependency)testShellDep);
        ((ResourceFacet)this.project.getFacet(ResourceFacet.class)).createResource("<forge/>".toCharArray(), "META-INF/forge.xml");
        return true;
    }

    public boolean isInstalled() {
        DependencyBuilder dep = DependencyBuilder.create((String)"org.jboss.forge:forge-shell-api");
        PackagingType packagingType = ((PackagingFacet)this.project.getFacet(PackagingFacet.class)).getPackagingType();
        return ((DependencyFacet)this.project.getFacet(DependencyFacet.class)).hasEffectiveDependency((Dependency)dep) && PackagingType.JAR.equals((Object)packagingType);
    }
}

