/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.dev.mvn;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.model.Dependency;
import org.jboss.forge.maven.resources.MavenDependencyResource;
import org.jboss.forge.maven.resources.MavenPomResource;
import org.jboss.forge.maven.resources.MavenProfileResource;
import org.jboss.forge.maven.resources.MavenRepositoryResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Current;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresResource;
import org.jboss.forge.shell.plugins.Topic;

@Alias(value="ls")
@RequiresResource(value={MavenPomResource.class})
@Topic(value="File & Resources")
@Help(value="Prints the contents current pom file")
public class LsMavenPomPlugin
implements Plugin {
    @Inject
    @Current
    private MavenPomResource pom;

    @DefaultCommand
    public void run(@Option(flagOnly=true, name="all", shortName="a", required=false) boolean showAll, @Option(flagOnly=true, name="list", shortName="l", required=false) boolean list, @Option(description="path", defaultValue=".") Resource<?>[] paths, PipeOut out) throws IOException {
        if (showAll) {
            int c;
            InputStream stream = this.pom.getResourceInputStream();
            StringBuilder buf = new StringBuilder();
            while ((c = stream.read()) != -1) {
                buf.append((char)c);
            }
            out.println(buf.toString());
        } else {
            out.println();
            out.println(out.renderColor(ShellColor.RED, "[dependencies] "));
            List children = this.pom.listResources();
            for (Resource child : children) {
                if (!(child instanceof MavenDependencyResource)) continue;
                MavenDependencyResource resource = (MavenDependencyResource)child;
                Dependency dep = resource.getDependency();
                out.println(out.renderColor(ShellColor.BLUE, dep.getGroupId()) + out.renderColor(ShellColor.BOLD, " : ") + out.renderColor(ShellColor.BLUE, dep.getArtifactId()) + out.renderColor(ShellColor.BOLD, " : ") + out.renderColor(ShellColor.NONE, dep.getVersion() == null ? "" : dep.getVersion()) + out.renderColor(ShellColor.BOLD, " : ") + out.renderColor(ShellColor.NONE, dep.getType() == null ? "" : dep.getType().toLowerCase()) + out.renderColor(ShellColor.BOLD, " : ") + out.renderColor(this.determineDependencyShellColor(dep.getScope()), dep.getScope() == null ? "compile" : dep.getScope().toLowerCase()));
            }
            out.println();
            out.println(out.renderColor(ShellColor.RED, "[profiles] "));
            for (Resource child : children) {
                if (!(child instanceof MavenProfileResource)) continue;
                out.println(out.renderColor(ShellColor.BLUE, child.getName()));
            }
            out.println();
            out.println(out.renderColor(ShellColor.RED, "[repositories] "));
            for (Resource child : children) {
                if (!(child instanceof MavenRepositoryResource)) continue;
                out.println(out.renderColor(ShellColor.BLUE, child.getName()) + " -> " + ((MavenRepositoryResource)child).getURL());
            }
        }
    }

    private ShellColor determineDependencyShellColor(String string) {
        if (string == null) {
            return ShellColor.YELLOW;
        }
        if ("provided".equalsIgnoreCase(string)) {
            return ShellColor.GREEN;
        }
        if ("compile".equalsIgnoreCase(string)) {
            return ShellColor.YELLOW;
        }
        if ("runtime".equalsIgnoreCase(string)) {
            return ShellColor.MAGENTA;
        }
        if ("system".equalsIgnoreCase(string)) {
            return ShellColor.BLACK;
        }
        if ("test".equalsIgnoreCase(string)) {
            return ShellColor.BLUE;
        }
        return ShellColor.NONE;
    }
}

