/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.bus;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.bus.cdi.BusManaged;
import org.jboss.forge.bus.cdi.ObserverCaptureExtension;
import org.jboss.forge.bus.event.BusEvent;
import org.jboss.forge.bus.spi.EventBusGroomer;
import org.jboss.forge.bus.util.Annotations;

@Singleton
public class EventBus {
    @Inject
    private BeanManager manager;
    @Inject
    private ObserverCaptureExtension extension;
    private final Map<Object, Annotation[]> map = new HashMap<Object, Annotation[]>();
    private List<Object> events = new ArrayList<Object>();
    boolean firing = false;
    private ArrayList<EventBusGroomer> groomers;

    private void observeAll(@Observes @Any Object event) {
        if (this.handles(event) && !this.hasQueued(event)) {
            this.enqueue(event);
        }
    }

    public void enqueue(Object event) {
        if (!this.firing) {
            this.events.add(event);
            this.map.put(event, new Annotation[0]);
        }
    }

    public void enqueue(Object event, Annotation[] qualifiers) {
        if (!this.firing) {
            this.events.add(event);
            this.map.put(event, qualifiers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAll() {
        this.firing = true;
        ArrayList<Exception> thrown = new ArrayList<Exception>();
        if (this.groomers == null) {
            this.groomers = new ArrayList();
            ServiceLoader<EventBusGroomer> services = ServiceLoader.load(EventBusGroomer.class);
            for (EventBusGroomer groomer : services) {
                this.groomers.add(groomer);
            }
        }
        for (EventBusGroomer groomer : this.groomers) {
            this.events = groomer.groom(this.events);
        }
        try {
            for (Object event : this.events) {
                if (this.map.containsKey(event)) {
                    try {
                        Annotation[] value = this.map.get(event);
                        this.fireSingle(event, value);
                    }
                    catch (Exception e1) {
                        thrown.add(e1);
                    }
                    continue;
                }
                throw new IllegalStateException("Queued event was not found in event Map");
            }
        }
        finally {
            this.firing = false;
            this.map.clear();
            this.events.clear();
        }
    }

    public boolean hasQueued(Object event) {
        return this.map.containsKey(event);
    }

    public void fireSingle(Object event) {
        List<BusManaged> qualifiers = this.extension.getEventQualifiers(event.getClass());
        this.fireSingle(event, qualifiers.toArray(new Annotation[0]));
    }

    public void fireSingle(Object event, Annotation ... annotations) {
        List<BusManaged> qualifiers = this.extension.getEventQualifiers(event.getClass());
        for (BusManaged managed : qualifiers) {
            ArrayList<Annotation> toFire = new ArrayList<Annotation>();
            toFire.addAll(Arrays.asList(annotations));
            toFire.add(managed);
            this.manager.fireEvent(event, toFire.toArray(new Annotation[0]));
        }
    }

    public boolean handles(Object event) {
        return Annotations.isAnnotationPresent(event.getClass(), BusEvent.class);
    }
}

