/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.bus.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class Annotations {
    public static boolean isAnnotationPresent(Method m, Class<? extends Annotation> type) {
        boolean result = false;
        if (m.isAnnotationPresent(type)) {
            result = true;
        } else {
            for (Annotation a : m.getAnnotations()) {
                if (!Annotations.isAnnotationPresent(a, type)) continue;
                result = true;
                break;
            }
        }
        if (!result) {
            result = Annotations.isAnnotationPresent(m.getDeclaringClass(), type);
        }
        return result;
    }

    private static boolean isAnnotationPresent(Annotation a, Class<? extends Annotation> type) {
        boolean result = false;
        if (a.annotationType().isAnnotationPresent(type)) {
            result = true;
        } else {
            for (Annotation nested : a.getClass().getAnnotations()) {
                if (!Annotations.isAnnotationPresent(nested, type)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean isAnnotationPresent(Class<?> c, Class<? extends Annotation> type) {
        boolean result = false;
        if (c.isAnnotationPresent(type)) {
            result = true;
        } else {
            for (Annotation a : c.getAnnotations()) {
                if (!Annotations.isAnnotationPresent(a, type)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static <A extends Annotation> A getAnnotation(Method m, Class<A> type) {
        A result = m.getAnnotation(type);
        if (result == null) {
            Annotation a;
            Annotation[] annotationArray = m.getAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n && (result = Annotations.getAnnotation(a = annotationArray[i], type)) == null; ++i) {
            }
        }
        if (result == null) {
            result = Annotations.getAnnotation(m.getDeclaringClass(), type);
        }
        return result;
    }

    public static <A extends Annotation> A getAnnotation(Annotation a, Class<A> type) {
        HashSet<Annotation> seen = new HashSet<Annotation>();
        return Annotations.getAnnotation(seen, a, type);
    }

    private static <A extends Annotation> A getAnnotation(Set<Annotation> seen, Annotation a, Class<A> type) {
        seen.add(a);
        Annotation result = null;
        if (type.isAssignableFrom(a.getClass())) {
            result = a;
        }
        if (result == null) {
            result = a.annotationType().getAnnotation(type);
        }
        if (result == null) {
            result = Annotations.getAnnotation(a.annotationType().getDeclaringClass(), type);
        }
        if (result == null) {
            for (Annotation nested : a.annotationType().getAnnotations()) {
                if (!seen.contains(nested) && (result = Annotations.getAnnotation(seen, nested, type)) != null) break;
            }
        }
        return (A)result;
    }

    public static <A extends Annotation> A getAnnotation(Class<?> c, Class<A> type) {
        if (c != null) {
            A result = c.getAnnotation(type);
            if (result == null) {
                for (Annotation a : c.getAnnotations()) {
                    if (!a.annotationType().isAnnotationPresent(type)) continue;
                    result = a.annotationType().getAnnotation(type);
                }
            }
            return result;
        }
        return null;
    }
}

