/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.jsf;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.jboss.forge.parser.xml.Node;
import org.jboss.forge.parser.xml.XMLParser;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyInstaller;
import org.jboss.forge.project.facets.MetadataFacet;
import org.jboss.forge.project.facets.WebResourceFacet;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.UnknownFileResource;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.util.Streams;
import org.jboss.forge.spec.javaee.BaseJavaEEFacet;
import org.jboss.forge.spec.javaee.FacesFacet;
import org.jboss.forge.spec.javaee.ServletFacet;
import org.jboss.forge.spec.javaee.util.ServletUtil;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.FacesProjectStage;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.ServletDef;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.ServletMappingDef;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.WebAppDescriptor;

@Alias(value="forge.spec.jsf")
@RequiresFacet(value={ServletFacet.class})
public class FacesFacetImpl
extends BaseJavaEEFacet
implements FacesFacet {
    private ShellPrintWriter out;
    private ServletMappingHelper servletMappingHelper = new ServletMappingHelper();

    @Inject
    public FacesFacetImpl(DependencyInstaller installer, ShellPrintWriter out) {
        super(installer);
        this.out = out;
    }

    @Override
    public boolean isInstalled() {
        String version = ((ServletFacet)this.project.getFacet(ServletFacet.class)).getConfig().getVersion();
        return version == null || version.trim().startsWith("3");
    }

    @Override
    public boolean install() {
        if (!this.getConfigFile().exists() && !this.getConfigFile().createNewFile()) {
            throw new RuntimeException("Failed to create required [" + this.getConfigFile().getFullyQualifiedName() + "]");
        }
        this.getConfigFile().setContents(((Object)((Object)this)).getClass().getResourceAsStream("/org/jboss/forge/web/faces-config.xml"));
        return super.install();
    }

    @Override
    protected List<Dependency> getRequiredDependencies() {
        return Arrays.asList(new Object[0]);
    }

    public FileResource<?> getConfigFile() {
        DirectoryResource webRoot = ((WebResourceFacet)this.project.getFacet(WebResourceFacet.class)).getWebRootDirectory();
        FileResource child = (FileResource)webRoot.getChild("WEB-INF" + File.separator + "faces-config.xml");
        if (!child.exists()) {
            return new UnknownFileResource(child.getResourceFactory(), child.getUnderlyingResourceObject()){

                public InputStream getResourceInputStream() {
                    if (!this.exists()) {
                        String projectName = ((MetadataFacet)FacesFacetImpl.this.project.getFacet(MetadataFacet.class)).getProjectName();
                        WebAppDescriptor unit = ((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).displayName(projectName).sessionTimeout(30);
                        return Streams.fromString((String)unit.exportAsString());
                    }
                    return super.getResourceInputStream();
                }

                public UnknownFileResource setContents(InputStream data) {
                    if (!this.exists()) {
                        this.createNewFile();
                    }
                    return (UnknownFileResource)super.setContents(data);
                }

                public UnknownFileResource setContents(char[] data) {
                    if (!this.exists()) {
                        this.createNewFile();
                    }
                    return (UnknownFileResource)super.setContents(data);
                }

                public UnknownFileResource setContents(String data) {
                    if (!this.exists()) {
                        this.createNewFile();
                    }
                    return (UnknownFileResource)super.setContents(data);
                }
            };
        }
        return child;
    }

    public FacesProjectStage getProjectStage() {
        ServletFacet facet = (ServletFacet)this.project.getFacet(ServletFacet.class);
        WebAppDescriptor config = facet.getConfig();
        return config.getFacesProjectStage();
    }

    public List<String> getFacesServletMappings() {
        ServletFacet facet = (ServletFacet)this.project.getFacet(ServletFacet.class);
        WebAppDescriptor webXml = facet.getConfig();
        return this.getExplicitFacesServletMappings(webXml);
    }

    public List<String> getEffectiveFacesServletMappings() {
        ArrayList<String> results = new ArrayList<String>();
        ServletFacet facet = (ServletFacet)this.project.getFacet(ServletFacet.class);
        WebAppDescriptor webXml = facet.getConfig();
        if (webXml.hasFacesServlet()) {
            results.addAll(this.getExplicitFacesServletMappings(webXml));
        } else if (webXml.getVersion().startsWith("3")) {
            results.add("*.jsf");
            results.add("/faces/*");
        } else {
            ShellMessages.info((ShellPrintWriter)this.out, (String)"FacesServlet not found in web.xml and Servlet Version not >= 3.0, could not discover FacesServlet mappings");
        }
        return results;
    }

    private List<String> getExplicitFacesServletMappings(WebAppDescriptor webXml) {
        List servlets = webXml.getServlets();
        ArrayList<String> results = new ArrayList<String>();
        for (ServletDef servlet : servlets) {
            if (!"javax.faces.webapp.FacesServlet".equals(servlet.getServletClass())) continue;
            List mappings = servlet.getMappings();
            for (ServletMappingDef mapping : mappings) {
                results.addAll(mapping.getUrlPatterns());
            }
        }
        return results;
    }

    public void setFacesMapping(String mapping) {
        InputStream newWebXml;
        ServletFacet facet = (ServletFacet)this.project.getFacet(ServletFacet.class);
        InputStream webXml = facet.getConfigFile().getResourceInputStream();
        if (webXml != (newWebXml = this.servletMappingHelper.addFacesServletMapping(webXml, mapping))) {
            facet.getConfigFile().setContents(newWebXml);
        }
        Streams.closeQuietly((Closeable)webXml);
        Streams.closeQuietly((Closeable)newWebXml);
    }

    public List<String> getWebPaths(Resource<?> r) {
        if (r != null) {
            WebResourceFacet web = (WebResourceFacet)this.project.getFacet(WebResourceFacet.class);
            List webRootDirectories = web.getWebRootDirectories();
            for (DirectoryResource d : webRootDirectories) {
                if (!r.getFullyQualifiedName().startsWith(d.getFullyQualifiedName())) continue;
                String path = r.getFullyQualifiedName().substring(d.getFullyQualifiedName().length());
                return this.getWebPaths(path);
            }
        }
        return new ArrayList<String>();
    }

    public List<String> getWebPaths(String path) {
        ArrayList<String> results = new ArrayList<String>();
        if (this.getResourceForWebPath(path) == null) {
            List<String> mappings = this.getEffectiveFacesServletMappings();
            for (String mapping : mappings) {
                String viewId = this.buildFacesViewId(mapping, path);
                if (results.contains(viewId)) continue;
                results.add(viewId);
            }
        }
        return results;
    }

    public Resource<?> getResourceForWebPath(String path) {
        if (path != null) {
            WebResourceFacet web = (WebResourceFacet)this.project.getFacet(WebResourceFacet.class);
            List webRootDirectories = web.getWebRootDirectories();
            boolean matches = false;
            for (String mapping : this.getEffectiveFacesServletMappings()) {
                Matcher matcher = ServletUtil.mappingToRegex((String)mapping).matcher(path);
                if (!matcher.matches()) continue;
                path = matcher.group(1);
                matches = true;
                break;
            }
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!matches) {
                return null;
            }
            List<String> strings = Arrays.asList(path.split("/"));
            for (DirectoryResource d : webRootDirectories) {
                Resource child;
                LinkedList<String> queue = new LinkedList<String>();
                queue.addAll(strings);
                DirectoryResource temp = d;
                while (queue.size() > 1 && (child = temp.getChild((String)queue.remove())) != null && child.exists()) {
                    temp = child;
                    if (!queue.isEmpty()) continue;
                    return child;
                }
                if (temp == null) continue;
                String name = (String)queue.remove();
                for (String suffix : this.getFacesSuffixes()) {
                    Resource child2 = null;
                    child2 = name.endsWith(suffix) ? temp.getChild(name) : temp.getChild(name + suffix);
                    if (child2 == null || !child2.exists()) continue;
                    return child2;
                }
            }
        }
        return null;
    }

    private String buildFacesViewId(String servletMapping, String resourcePath) {
        for (String suffix : this.getFacesSuffixes()) {
            if (!resourcePath.endsWith(suffix)) continue;
            StringBuffer result = new StringBuffer();
            HashMap<Pattern, String> patterns = new HashMap<Pattern, String>();
            Pattern pathMapping = Pattern.compile("^(/.*)/\\*$");
            Pattern extensionMapping = Pattern.compile("^\\*(\\..*)$");
            Pattern defaultMapping = Pattern.compile("^/\\*$");
            patterns.put(pathMapping, "$1" + resourcePath);
            patterns.put(extensionMapping, resourcePath.replaceAll("^(.*)(\\.\\w+)$", "$1") + "$1");
            patterns.put(defaultMapping, resourcePath);
            boolean matched = false;
            Iterator iterator = patterns.keySet().iterator();
            while (!matched && iterator.hasNext()) {
                Pattern p = (Pattern)iterator.next();
                Matcher m = p.matcher(servletMapping);
                if (!m.matches()) continue;
                String replacement = (String)patterns.get(p);
                m.appendReplacement(result, replacement);
                matched = true;
            }
            if (!matched) {
                return null;
            }
            return result.toString();
        }
        return resourcePath;
    }

    public List<String> getFacesSuffixes() {
        List<String> suffixes = this.getFacesDefaultSuffixes();
        for (String s : this.getFaceletsDefaultSuffixes()) {
            if (suffixes.contains(s)) continue;
            suffixes.add(s);
        }
        return suffixes;
    }

    public List<String> getFacesDefaultSuffixes() {
        ServletFacet facet = (ServletFacet)this.project.getFacet(ServletFacet.class);
        WebAppDescriptor webXml = facet.getConfig();
        return webXml.getFacesDefaultSuffixes();
    }

    public List<String> getFaceletsDefaultSuffixes() {
        ServletFacet facet = (ServletFacet)this.project.getFacet(ServletFacet.class);
        WebAppDescriptor webXml = facet.getConfig();
        return webXml.getFaceletsDefaultSuffixes();
    }

    public List<String> getFaceletsViewMapping() {
        ServletFacet facet = (ServletFacet)this.project.getFacet(ServletFacet.class);
        WebAppDescriptor webXml = facet.getConfig();
        return webXml.getFaceletsViewMappings();
    }

    public static class ServletMappingHelper {
        public static final String FACES_SERVLET_CLASS = "javax.faces.webapp.FacesServlet";

        public InputStream addFacesServletMapping(InputStream webXmlStream, String mapping) {
            Node facesServlet;
            Node root = XMLParser.parse((InputStream)webXmlStream);
            boolean mappingCreated = this.createMappingIfNotExists(root, facesServlet = this.getOrCreateFacesServlet(root), mapping);
            if (mappingCreated) {
                return XMLParser.toXMLInputStream((Node)root);
            }
            return XMLParser.toXMLInputStream((Node)root);
        }

        public Node getOrCreateFacesServlet(Node root) {
            List servlets = root.get("servlet");
            for (Node servlet : servlets) {
                if (!FACES_SERVLET_CLASS.equals(servlet.getSingle("servlet-class").getText())) continue;
                return servlet;
            }
            Node servlet = root.createChild("servlet");
            servlet.createChild("servlet-name").text("Faces Servlet");
            servlet.createChild("servlet-class").text(FACES_SERVLET_CLASS);
            servlet.createChild("load-on-startup").text("1");
            return servlet;
        }

        boolean createMappingIfNotExists(Node root, Node servlet, String mapping) {
            List servletMappings = root.get("servlet-mapping");
            Node servletMappingNode = null;
            String servletName = servlet.getSingle("servlet-name").getText();
            for (Node servletMapping : servletMappings) {
                if (!servletName.equals(servletMapping.getSingle("servlet-name").getText())) continue;
                servletMappingNode = servletMapping;
                List urlPatterns = servletMapping.get("url-pattern");
                for (Node urlPattern : urlPatterns) {
                    if (!mapping.equals(urlPattern.getText())) continue;
                    return false;
                }
            }
            if (servletMappingNode == null) {
                servletMappingNode = root.createChild("servlet-mapping");
                servletMappingNode.createChild("servlet-name").text(servletName);
            }
            servletMappingNode.createChild("url-pattern").text(mapping);
            return true;
        }
    }
}

