/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.rest;

import java.io.FileNotFoundException;
import javax.inject.Inject;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Type;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.util.Packages;
import org.jboss.forge.spec.javaee.rest.DTOClassBuilder;
import org.jboss.forge.spec.javaee.rest.DTOCollection;
import org.jboss.forge.spec.javaee.util.JPABean;
import org.jboss.forge.spec.javaee.util.JPAProperty;

public class RootAndNestedDtoGenerator {
    @Inject
    private JavaSourceFacet java;
    @Inject
    private ShellPrintWriter writer;
    @Inject
    private DTOCollection dtoCollection;

    public DTOCollection from(JavaClass entity, String dtoPackage) {
        if (entity == null) {
            throw new IllegalArgumentException("The argument entity was null.");
        }
        this.generatedDTOGraphForEntity(entity, dtoPackage, true, false);
        return this.dtoCollection;
    }

    private JavaClass generatedDTOGraphForEntity(JavaClass entity, String dtoPackage, boolean topLevel, boolean isEmbeddedType) {
        if (this.dtoCollection.containsDTOFor(entity, topLevel)) {
            return this.dtoCollection.getDTOFor(entity, topLevel);
        }
        JPAProperty idProperty = null;
        JPABean bean = new JPABean(entity);
        idProperty = this.parseIdPropertyForJPAEntity(bean);
        DTOClassBuilder dtoClassBuilder = new DTOClassBuilder(entity, idProperty, topLevel).setPackage(dtoPackage).setEmbeddedType(isEmbeddedType);
        for (JPAProperty property : bean.getProperties()) {
            boolean isEmbedded;
            if (property.isTransient() || property.hasAnnotation(Transient.class)) continue;
            String qualifiedPropertyType = property.getQualifiedType();
            JavaClass propertyClass = this.tryGetJavaClass(qualifiedPropertyType);
            boolean isReadable = property.isReadable();
            boolean isCollection = property.hasAnnotation(OneToMany.class) || property.hasAnnotation(ManyToMany.class);
            Type<?> propertyTypeInspector = property.getType();
            boolean parameterized = propertyTypeInspector.isParameterized();
            boolean hasAssociation = property.hasAnnotation(OneToOne.class) || property.hasAnnotation(ManyToOne.class);
            boolean bl = isEmbedded = property.hasAnnotation(Embedded.class) || propertyClass != null && propertyClass.hasAnnotation(Embeddable.class);
            if (!isReadable) continue;
            if (isCollection && parameterized) {
                if (!topLevel) continue;
                Type type = (Type)propertyTypeInspector.getTypeArguments().get(0);
                String qualifiedParameterizedType = type.getQualifiedName();
                JavaClass parameterizedClass = this.tryGetJavaClass(qualifiedParameterizedType);
                if (parameterizedClass == null) {
                    ShellMessages.warn((ShellPrintWriter)this.writer, (String)("Omitting creation of fields and DTO for type " + qualifiedParameterizedType + " due to missing source."));
                    continue;
                }
                JavaClass nestedDTOClass = this.generatedDTOGraphForEntity(parameterizedClass, dtoPackage, false, false);
                JPABean parameterizedClassBean = new JPABean(parameterizedClass);
                JPAProperty nestedDtoId = this.parseIdPropertyForJPAEntity(parameterizedClassBean);
                dtoClassBuilder.updateForCollectionProperty(property, nestedDTOClass, type, nestedDtoId);
                continue;
            }
            if (hasAssociation) {
                if (!topLevel) continue;
                JavaClass associatedClass = this.tryGetJavaClass(qualifiedPropertyType);
                if (associatedClass == null) {
                    ShellMessages.warn((ShellPrintWriter)this.writer, (String)("Omitting creation of fields and DTO for type " + qualifiedPropertyType + " due to missing source."));
                    continue;
                }
                JavaClass nestedDTOClass = this.generatedDTOGraphForEntity(associatedClass, dtoPackage, false, false);
                dtoClassBuilder.updateForReferencedProperty(property, nestedDTOClass);
                continue;
            }
            if (isEmbedded) {
                JavaClass dtoForEmbeddedType = this.generatedDTOGraphForEntity(propertyClass, dtoPackage, true, true);
                dtoClassBuilder.updateForReferencedProperty(property, dtoForEmbeddedType);
                continue;
            }
            dtoClassBuilder.updateForSimpleProperty(property, property.getType());
        }
        JavaClass dtoClass = dtoClassBuilder.createDTO();
        if (topLevel) {
            this.dtoCollection.addRootDTO(entity, dtoClass);
        } else {
            this.dtoCollection.addNestedDTO(entity, dtoClass);
        }
        return dtoClass;
    }

    private JPAProperty parseIdPropertyForJPAEntity(JPABean bean) {
        for (JPAProperty property : bean.getProperties()) {
            if (!property.hasAnnotation(Id.class)) continue;
            return property;
        }
        return null;
    }

    private JavaClass tryGetJavaClass(String qualifiedFieldType) {
        try {
            JavaResource javaResource = this.java.getJavaResource(Packages.toFileSyntax((String)qualifiedFieldType));
            JavaSource javaSource = javaResource.getJavaSource();
            if (javaSource instanceof JavaClass) {
                return (JavaClass)javaSource;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return null;
    }
}

