/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.jpa;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.Entity;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.DependencyInstaller;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.facets.ResourceFacet;
import org.jboss.forge.project.packaging.PackagingType;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresPackagingType;
import org.jboss.forge.spec.javaee.BaseJavaEEFacet;
import org.jboss.forge.spec.javaee.PersistenceFacet;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.PersistenceDescriptor;

@Alias(value="forge.spec.jpa")
@RequiresFacet(value={JavaSourceFacet.class, ResourceFacet.class, DependencyFacet.class})
@RequiresPackagingType(value={PackagingType.JAR, PackagingType.WAR, PackagingType.BUNDLE})
public class PersistenceFacetImpl
extends BaseJavaEEFacet
implements PersistenceFacet {
    public static final String DEFAULT_ENTITY_PACKAGE = "model";

    @Inject
    public PersistenceFacetImpl(DependencyInstaller installer) {
        super(installer);
    }

    @Override
    protected List<Dependency> getRequiredDependencies() {
        return Arrays.asList(DependencyBuilder.create((String)"org.hibernate.javax.persistence:hibernate-jpa-2.0-api"));
    }

    @Override
    public boolean install() {
        FileResource<?> descriptor;
        if (!this.isInstalled() && !(descriptor = this.getConfigFile()).exists()) {
            this.createDefaultConfig(descriptor);
        }
        return super.install();
    }

    @Override
    public boolean isInstalled() {
        return super.isInstalled() && this.getConfigFile().exists();
    }

    public String getEntityPackage() {
        JavaSourceFacet sourceFacet = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        return sourceFacet.getBasePackage() + "." + DEFAULT_ENTITY_PACKAGE;
    }

    public DirectoryResource getEntityPackageDir() {
        JavaSourceFacet sourceFacet = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        DirectoryResource entityRoot = sourceFacet.getBasePackageResource().getChildDirectory(DEFAULT_ENTITY_PACKAGE);
        if (!entityRoot.exists()) {
            entityRoot.mkdirs();
        }
        return entityRoot;
    }

    public PersistenceDescriptor getConfig() {
        DescriptorImporter importer = Descriptors.importAs(PersistenceDescriptor.class);
        FileResource<?> configFile = this.getConfigFile();
        if (!configFile.exists()) {
            this.createDefaultConfig(configFile);
        }
        PersistenceDescriptor descriptor = (PersistenceDescriptor)importer.from(configFile.getResourceInputStream());
        return descriptor;
    }

    private void createDefaultConfig(FileResource<?> descriptor) {
        PersistenceDescriptor descriptorContents = ((PersistenceDescriptor)Descriptors.create(PersistenceDescriptor.class)).version("2.0");
        descriptor.setContents(descriptorContents.exportAsString());
    }

    public void saveConfig(PersistenceDescriptor descriptor) {
        String output = descriptor.exportAsString();
        this.getConfigFile().setContents(output);
    }

    public FileResource<?> getConfigFile() {
        ResourceFacet resources = (ResourceFacet)this.project.getFacet(ResourceFacet.class);
        return (FileResource)resources.getResourceFolder().getChild("META-INF" + File.separator + "persistence.xml");
    }

    public List<JavaClass> getAllEntities() {
        DirectoryResource packageFile = this.getEntityPackageDir();
        return this.findEntitiesInFolder(packageFile);
    }

    private List<JavaClass> findEntitiesInFolder(DirectoryResource packageFile) {
        ArrayList<JavaClass> result = new ArrayList<JavaClass>();
        if (packageFile.exists()) {
            for (Resource source : packageFile.listResources()) {
                if (!(source instanceof JavaResource)) continue;
                try {
                    JavaSource javaClass = ((JavaResource)source).getJavaSource();
                    if (!javaClass.hasAnnotation(Entity.class) || !javaClass.isClass()) continue;
                    result.add((JavaClass)javaClass);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            for (Resource source : packageFile.listResources()) {
                if (!(source instanceof DirectoryResource)) continue;
                List<JavaClass> subResults = this.findEntitiesInFolder((DirectoryResource)source);
                result.addAll(subResults);
            }
        }
        return result;
    }
}

