/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.jsf;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.events.InstallFacets;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.ShellPrompt;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.SetupCommand;
import org.jboss.forge.spec.javaee.CDIFacet;
import org.jboss.forge.spec.javaee.FacesAPIFacet;
import org.jboss.forge.spec.javaee.FacesFacet;
import org.jboss.forge.spec.javaee.ServletFacet;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.FacesProjectStage;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.WebAppDescriptor;

@Alias(value="faces")
@RequiresFacet(value={FacesFacet.class})
@RequiresProject
public class FacesPlugin
implements Plugin {
    @Inject
    private Project project;
    @Inject
    private Event<InstallFacets> request;
    @Inject
    private ShellPrompt prompt;
    private static final String VIEW_TEMPLATE = "org/jboss/forge/web/empty-view.xhtml";

    @SetupCommand
    public void setup(PipeOut out) {
        String servletVersion;
        int majorVersion;
        FacesFacet facet;
        if (!this.project.hasFacet(FacesAPIFacet.class)) {
            this.request.fire((Object)new InstallFacets(FacesAPIFacet.class));
            if (!this.project.hasFacet(CDIFacet.class) && this.prompt.promptBoolean("Do you also want to install CDI?", true)) {
                this.request.fire((Object)new InstallFacets(CDIFacet.class));
            }
        }
        if ((facet = (FacesFacet)this.project.getFacet(FacesFacet.class)).getFacesServletMappings().isEmpty() && ((majorVersion = Integer.parseInt((servletVersion = ((ServletFacet)this.project.getFacet(ServletFacet.class)).getConfig().getVersion()).split("[.]")[0])) < 3 || this.prompt.promptBoolean("Do you also want to install the Faces servlet and mapping?", false))) {
            facet.setFacesMapping("*.xhtml");
            facet.setFacesMapping("/faces/*");
        }
        if (this.project.hasFacet(FacesFacet.class)) {
            ShellMessages.success((ShellPrintWriter)out, (String)"JavaServer Faces is installed.");
        }
    }

    @Command(value="project-stage")
    public void setProjectStage(@Option(name="set") FacesProjectStage stage, PipeOut out) {
        ServletFacet srv = (ServletFacet)this.project.getFacet(ServletFacet.class);
        WebAppDescriptor config = srv.getConfig();
        if (stage == null) {
            ShellMessages.info((ShellPrintWriter)out, (String)("Project stage is currently: " + config.getFacesProjectStage().getStage()));
        } else {
            config.facesProjectStage(stage);
            srv.saveConfig(config);
            ShellMessages.success((ShellPrintWriter)out, (String)("Faces PROJECT_STAGE updated to: " + stage.getStage()));
        }
    }

    @DefaultCommand
    public void show(PipeOut out) {
        FacesFacet facet = (FacesFacet)this.project.getFacet(FacesFacet.class);
        ShellMessages.info((ShellPrintWriter)out, (String)"Displaying current JSF configuration:");
        out.println();
        out.println(out.renderColor(ShellColor.BOLD, "Project State: ") + facet.getProjectStage());
        out.println(out.renderColor(ShellColor.BOLD, "FacesServlet Mappings: ") + facet.getEffectiveFacesServletMappings());
        out.println(out.renderColor(ShellColor.BOLD, "Faces Default Suffixes: ") + facet.getFacesDefaultSuffixes());
        out.println(out.renderColor(ShellColor.BOLD, "Facelets Default Suffixes: ") + facet.getFaceletsDefaultSuffixes());
        out.println(out.renderColor(ShellColor.BOLD, "Facelets View Mappings: ") + facet.getFaceletsViewMapping());
    }

    @Command(value="new-view")
    public void newView(PipeOut out, @Option(name="target") Resource<?> target) {
        Configuration freemarkerConfig = new Configuration();
        freemarkerConfig.setClassForTemplateLoading(this.getClass(), "/");
        freemarkerConfig.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        HashMap map = new HashMap();
        StringWriter output = new StringWriter();
        try {
            Template templateFile = freemarkerConfig.getTemplate(VIEW_TEMPLATE);
            templateFile.process(map, (Writer)output);
            ((Writer)output).flush();
        }
        catch (IOException ioEx) {
            throw new RuntimeException(ioEx);
        }
        catch (TemplateException templateEx) {
            throw new RuntimeException(templateEx);
        }
        if (!target.exists()) {
            ((FileResource)target).createNewFile();
            ((FileResource)target).setContents(((Object)output).toString());
        } else if (this.prompt.promptBoolean("File exists. Overwrite with blank view?")) {
            ((FileResource)target).setContents(((Object)output).toString());
        } else {
            throw new RuntimeException("Aborted. File exists [" + target.getFullyQualifiedName() + "].");
        }
    }
}

