/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.rest;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.Type;
import org.jboss.forge.parser.java.util.Refactory;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.parser.java.util.Types;
import org.jboss.forge.spec.javaee.util.FreemarkerTemplateProcessor;
import org.jboss.forge.spec.javaee.util.JPAProperty;

public class DTOClassBuilder {
    private JavaClass dto;
    private boolean topLevel = false;
    private String dtoClassName;
    private boolean isEmbeddedType;
    private JavaClass entity;
    private StringBuilder copyCtorBuilder;
    private StringBuilder assembleJPABuilder;
    private Method<JavaClass> assembleJPA;
    private Method<JavaClass> copyCtor;
    private JPAProperty idProperty;
    private FreemarkerTemplateProcessor processor;

    public DTOClassBuilder(JavaClass entity, JPAProperty idProperty, boolean topLevel) {
        this.entity = entity;
        this.idProperty = idProperty;
        this.topLevel = topLevel;
        this.copyCtorBuilder = new StringBuilder();
        this.assembleJPABuilder = new StringBuilder();
        this.processor = new FreemarkerTemplateProcessor();
        this.initName();
        this.initClassStructure();
        this.initializeJPAEntityInAssembler();
    }

    public DTOClassBuilder setPackage(String dtoPackage) {
        this.dto.setPackage(dtoPackage);
        return this;
    }

    public DTOClassBuilder setEmbeddedType(boolean isEmbeddedType) {
        this.isEmbeddedType = isEmbeddedType;
        return this;
    }

    public DTOClassBuilder updateForCollectionProperty(JPAProperty property, JavaClass nestedDTOClass, Type<?> parameterizedType, JPAProperty nestedDTOId) {
        this.addCollectionProperty(property, nestedDTOClass);
        this.addInitializerFromCollection(property, nestedDTOClass, parameterizedType);
        this.addCollectionAssembler(property, parameterizedType, nestedDTOClass, nestedDTOId);
        return this;
    }

    public DTOClassBuilder updateForReferencedProperty(JPAProperty property, JavaClass nestedDTOClass) {
        this.addProperty(property, nestedDTOClass);
        this.addInitializerFromDTO(property, nestedDTOClass);
        if (property.isWritable()) {
            this.addAssemblerForReference(property);
        }
        return this;
    }

    public DTOClassBuilder updateForSimpleProperty(JPAProperty property, Type<?> type) {
        this.addProperty(property, property.getType());
        this.addInitializerFromProperty(property);
        if (!property.equals(this.idProperty) && property.isWritable()) {
            this.addPropertyAssembler(property);
        }
        return this;
    }

    public JavaClass createDTO() {
        if (this.topLevel && !this.isEmbeddedType) {
            this.dto.addAnnotation(XmlRootElement.class);
        }
        this.generateCopyConstructorBody();
        this.generateJPAAssemblerBody();
        return this.dto;
    }

    private void initName() {
        this.dtoClassName = (this.topLevel ? "" : "Nested") + this.entity.getName() + "DTO";
    }

    private void initClassStructure() {
        this.dto = (JavaClass)((JavaClass)((JavaClass)((JavaClass)JavaParser.create(JavaClass.class)).setName(this.dtoClassName)).setPublic()).addInterface(Serializable.class);
        this.createDefaultConstructor();
        this.createCopyConstructor();
        this.createJPAAssembler();
    }

    private void initializeJPAEntityInAssembler() {
        if (!this.topLevel) {
            this.dto.addImport(TypedQuery.class);
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put("id", this.idProperty.getName());
            map.put("entityName", this.entity.getName());
            map.put("jpqlVar", this.entity.getName().toLowerCase().substring(0, 1));
            String output = this.processor.processTemplate(map, "org/jboss/forge/rest/InitializeJPAEntityFromId.jv");
            this.assembleJPABuilder.append(output);
        }
    }

    private void createJPAAssembler() {
        this.assembleJPA = ((Method)((Method)this.dto.addMethod().setName("fromDTO")).setReturnType(this.entity.getName()).setPublic()).setParameters(this.entity.getName() + " entity, EntityManager em");
        this.assembleJPABuilder.append("if(entity == null) { entity = new " + this.entity.getName() + "(); }");
    }

    private void generateJPAAssemblerBody() {
        if (!this.isEmbeddedType) {
            this.assembleJPABuilder.append("entity = em.merge(entity);");
        }
        this.assembleJPABuilder.append("return entity;");
        this.assembleJPA.setBody(this.assembleJPABuilder.toString());
    }

    private void createCopyConstructor() {
        this.dto.addImport(this.entity.getQualifiedName());
        this.dto.addImport(EntityManager.class);
        this.copyCtor = ((Method)this.dto.addMethod().setConstructor(true).setPublic()).setParameters("final " + this.entity.getName() + " entity");
    }

    private void generateCopyConstructorBody() {
        this.copyCtor.setBody("if (entity != null) {\n" + this.copyCtorBuilder.toString() + "\n}");
    }

    private void createDefaultConstructor() {
        Method ctor = this.dto.addMethod();
        ctor.setConstructor(true);
        ctor.setPublic();
        ctor.setBody("");
    }

    private void addCollectionProperty(JPAProperty field, JavaClass nestedDTOClass) {
        String concreteCollectionType = null;
        String qualifiedConcreteCollectionType = null;
        String jpaCollectionType = field.getSimpleType();
        String nestedDTOType = nestedDTOClass.getName();
        String qualifiedDTOType = nestedDTOClass.getQualifiedName();
        if (jpaCollectionType.equals("Set")) {
            concreteCollectionType = "HashSet";
            qualifiedConcreteCollectionType = "java.util.HashSet";
        } else if (jpaCollectionType.equals("List")) {
            concreteCollectionType = "ArrayList";
            qualifiedConcreteCollectionType = "java.util.ArrayList";
        } else if (jpaCollectionType.equals("Map")) {
            concreteCollectionType = "HashMap";
            qualifiedConcreteCollectionType = "java.util.HashMap";
        }
        Field dtoField = this.dto.addField("private " + jpaCollectionType + "<" + nestedDTOType + "> " + field.getName() + "= new " + concreteCollectionType + "<" + nestedDTOType + ">();");
        this.dto.addImport(field.getQualifiedType());
        this.dto.addImport(qualifiedConcreteCollectionType);
        if (!Types.isJavaLang((String)qualifiedDTOType)) {
            this.dto.addImport(qualifiedDTOType);
        }
        Refactory.createGetterAndSetter((JavaClass)this.dto, (Field)dtoField);
    }

    private void addProperty(JPAProperty field, Type<?> dtoFieldType) {
        String arrayType;
        String simpleName = dtoFieldType.getName();
        String qualifiedName = dtoFieldType.getQualifiedName();
        Field dtoField = this.dto.addField("private " + simpleName + " " + field.getName() + ";");
        if (!(field.isPrimitive() || Types.isJavaLang((String)qualifiedName) || Types.isArray((String)qualifiedName))) {
            this.dto.addImport(qualifiedName);
        }
        if (Types.isArray((String)qualifiedName) && !Types.isJavaLang((String)(arrayType = field.getType().getQualifiedName())) && !Types.isPrimitive((String)arrayType)) {
            this.dto.addImport(arrayType);
        }
        Refactory.createGetterAndSetter((JavaClass)this.dto, (Field)dtoField);
    }

    private void addProperty(JPAProperty property, JavaClass dtoFieldType) {
        String arrayType;
        String simpleName = dtoFieldType.getName();
        String qualifiedName = dtoFieldType.getQualifiedName();
        Field dtoField = this.dto.addField("private " + simpleName + " " + property.getName() + ";");
        if (!(property.isPrimitive() || Types.isJavaLang((String)qualifiedName) || Types.isArray((String)qualifiedName))) {
            this.dto.addImport(qualifiedName);
        }
        if (Types.isArray((String)qualifiedName) && !Types.isJavaLang((String)(arrayType = property.getType().getQualifiedName())) && !Types.isPrimitive((String)arrayType)) {
            this.dto.addImport(arrayType);
        }
        Refactory.createGetterAndSetter((JavaClass)this.dto, (Field)dtoField);
    }

    private void addCollectionAssembler(JPAProperty property, Type<?> parameterizedType, JavaClass nestedDTOClass, JPAProperty nestedDtoId) {
        String fieldName = property.getName();
        String simpleParameterizedType = parameterizedType.getName();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("reverseIdGetter", nestedDtoId.getAccessor().getName() + "()");
        map.put("fieldName", fieldName);
        map.put("fieldGetter", property.getAccessor().getName() + "()");
        map.put("nestedDTOType", nestedDTOClass.getName());
        map.put("jpaIterator", "iter" + Strings.capitalize((String)fieldName));
        map.put("simpleParameterizedType", simpleParameterizedType);
        map.put("jpaVar", Strings.uncapitalize((String)simpleParameterizedType));
        map.put("dtoIterator", "iterDto" + Strings.capitalize((String)fieldName));
        map.put("dtoVar", "dto" + Strings.capitalize((String)simpleParameterizedType));
        map.put("jpqlVar", simpleParameterizedType.toLowerCase().substring(0, 1));
        String output = this.processor.processTemplate(map, "org/jboss/forge/rest/AssembleCollection.jv");
        this.assembleJPABuilder.append(output);
    }

    private void addAssemblerForReference(JPAProperty property) {
        String fieldName = property.getName();
        String fieldSetter = property.getMutator().getName();
        String fieldGetter = property.getAccessor().getName();
        this.assembleJPABuilder.append("if(this." + fieldName + " != null) {");
        this.assembleJPABuilder.append("entity." + fieldSetter + "(this." + fieldName + ".fromDTO(entity." + fieldGetter + "(), em));");
        this.assembleJPABuilder.append("}");
    }

    private void addPropertyAssembler(JPAProperty property) {
        String fieldName = property.getName();
        String fieldSetter = property.getMutator().getName();
        this.assembleJPABuilder.append("entity." + fieldSetter + "(this." + fieldName + ");");
    }

    private void addInitializerFromCollection(JPAProperty property, JavaClass nestedDTOClass, Type<?> parameterizedType) {
        this.dto.addImport(parameterizedType.getQualifiedName());
        this.dto.addImport(Iterator.class);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("fieldName", property.getName());
        map.put("nestedDTOType", nestedDTOClass.getName());
        map.put("collectionIterator", "iter" + Strings.capitalize((String)property.getName()));
        map.put("elementType", parameterizedType.getName());
        map.put("fieldGetter", property.getAccessor().getName() + "()");
        String output = this.processor.processTemplate(map, "org/jboss/forge/rest/InitializeNestedDTOCollection.jv");
        this.copyCtorBuilder.append(output);
    }

    private void addInitializerFromDTO(JPAProperty property, JavaClass dtoClass) {
        String fieldName = property.getName();
        String fieldGetter = property.getAccessor().getName();
        String dtoType = dtoClass.getName();
        this.copyCtorBuilder.append("this." + fieldName + " = " + "new " + dtoType + "(entity." + fieldGetter + "());");
    }

    private void addInitializerFromProperty(JPAProperty property) {
        String fieldName = property.getName();
        String fieldGetter = property.getAccessor().getName();
        this.copyCtorBuilder.append("this." + fieldName + " = " + "entity." + fieldGetter + "();");
    }
}

