/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.rest;

import java.io.FileNotFoundException;
import javax.inject.Inject;
import org.jboss.forge.env.Configuration;
import org.jboss.forge.env.ConfigurationFactory;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.resources.java.JavaResourceVisitor;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.spec.javaee.RestApplicationFacet;

@Alias(value="forge.spec.jaxrs.applicationclass")
@RequiresFacet(value={JavaSourceFacet.class})
public class RestApplicationFacetImpl
extends BaseFacet
implements RestApplicationFacet {
    private String classPackage;
    private String className;
    private String rootPath;
    @Inject
    private ConfigurationFactory configurationFactory;
    private Configuration configuration;

    public boolean install() {
        if (!this.isInstalled()) {
            JavaSourceFacet javaSourceFacet = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
            JavaClass applicationClass = (JavaClass)((JavaClass)((JavaClass)((JavaClass)((JavaClass)JavaParser.create(JavaClass.class)).setPackage(this.classPackage)).setName(this.className)).setSuperType("javax.ws.rs.core.Application")).addAnnotation("javax.ws.rs.ApplicationPath").setStringValue(this.rootPath).getOrigin();
            applicationClass.addImport("javax.ws.rs.core.Application");
            applicationClass.addImport("javax.ws.rs.ApplicationPath");
            try {
                javaSourceFacet.saveJavaSource((JavaSource)applicationClass);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public boolean isInstalled() {
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        Configuration projectConfiguration = this.getProjectConfiguration();
        this.classPackage = projectConfiguration.getString("rest.applicationclass.package");
        this.className = projectConfiguration.getString("rest.applicationclass.name");
        this.rootPath = projectConfiguration.getString("rootpath");
        if (!(this.classPackage != null && this.className != null || this.findApplicationClass())) {
            return false;
        }
        try {
            JavaResource javaResource = javaSourceFacet.getJavaResource(this.classPackage + "." + this.className);
            if (javaResource.exists() || this.findApplicationClass()) {
                return true;
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        return false;
    }

    private boolean findApplicationClass() {
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        Configuration projectConfiguration = this.getProjectConfiguration();
        projectConfiguration.clearProperty("rest.applicationclass.name");
        projectConfiguration.clearProperty("rest.applicationclass.package");
        javaSourceFacet.visitJavaSources(new JavaResourceVisitor(){
            Configuration configuration;
            boolean found;
            {
                this.configuration = RestApplicationFacetImpl.this.getProjectConfiguration();
                this.found = false;
            }

            public void visit(JavaResource javaResource) {
                if (!this.found) {
                    try {
                        if (javaResource.getJavaSource().getAnnotation("javax.ws.rs.ApplicationPath") != null) {
                            this.configuration.setProperty("rest.applicationclass.package", (Object)javaResource.getJavaSource().getPackage());
                            this.configuration.setProperty("rest.applicationclass.name", (Object)javaResource.getJavaSource().getName());
                            this.configuration.setProperty("rootpath", (Object)javaResource.getJavaSource().getAnnotation("javax.ws.rs.ApplicationPath").getStringValue());
                            this.found = true;
                        }
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        return projectConfiguration.getString("rest.applicationclass.name") != null;
    }

    public void setApplicationPath(String path) {
        this.getProjectConfiguration().setProperty("rootpath", (Object)path);
        if (this.classPackage == null || this.className == null) {
            this.reportConfigurationError(this.className);
        }
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        try {
            String classname = this.classPackage + "." + this.className;
            JavaResource javaResource = javaSourceFacet.getJavaResource(classname);
            if (!javaResource.exists()) {
                this.reportConfigurationError(classname);
            }
            javaResource.getJavaSource().getAnnotation("javax.ws.rs.ApplicationPath").setStringValue(path);
        }
        catch (FileNotFoundException e) {
            this.reportConfigurationError(this.className);
        }
    }

    private void reportConfigurationError(String classname) {
        throw new RuntimeException("Error setting application path. The class '" + classname + "' in your configuration file does not exist. Run rest setup again.");
    }

    private Configuration getProjectConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.configurationFactory.getProjectConfig(this.project);
        }
        return this.configuration;
    }
}

