/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.rest;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.jboss.forge.env.Configuration;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Member;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.util.Types;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.facets.events.InstallFacets;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.ShellPrompt;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Current;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.SetupCommand;
import org.jboss.forge.shell.project.ProjectScoped;
import org.jboss.forge.spec.javaee.EJBFacet;
import org.jboss.forge.spec.javaee.JTAFacet;
import org.jboss.forge.spec.javaee.PersistenceFacet;
import org.jboss.forge.spec.javaee.RestActivatorType;
import org.jboss.forge.spec.javaee.RestFacet;
import org.jboss.forge.spec.javaee.events.RestGeneratedResources;
import org.jboss.forge.spec.javaee.rest.ContentTypeCompleter;
import org.jboss.forge.spec.javaee.rest.EntityBasedResourceGenerator;
import org.jboss.forge.spec.javaee.rest.ResourceStrategy;
import org.jboss.forge.spec.javaee.rest.RootAndNestedDTOBasedResourceGenerator;

@Alias(value="rest")
@RequiresProject
public class RestPlugin
implements Plugin {
    @Inject
    private Project project;
    @Inject
    private Event<InstallFacets> request;
    @Inject
    private Event<RestGeneratedResources> generatedEvent;
    @Inject
    @Current
    private Resource<?> currentResource;
    @Inject
    private ShellPrompt prompt;
    @Inject
    @ProjectScoped
    Configuration configuration;
    @Inject
    EntityBasedResourceGenerator entityResourceGenerator;
    @Inject
    RootAndNestedDTOBasedResourceGenerator dtoResourceGenerator;

    @SetupCommand
    public void setup(@Option(name="activatorType", defaultValue="WEB_XML") RestActivatorType activatorType, PipeOut out) {
        if (!this.project.hasFacet(RestFacet.class)) {
            this.configuration.setProperty("activatorChoice", (Object)activatorType.toString());
            this.request.fire((Object)new InstallFacets(RestFacet.class));
        }
        if (this.project.hasFacet(RestFacet.class)) {
            ShellMessages.success((ShellPrintWriter)out, (String)"Rest Web Services (JAX-RS) is installed.");
        }
    }

    @Command(value="endpoint-from-entity", help="Creates a REST endpoint from an existing domain @Entity object")
    public void endpointFromEntity(PipeOut out, @Option(name="contentType", defaultValue="application/xml", completer=ContentTypeCompleter.class) String contentType, @Option(required=false) JavaResource[] targets, @Option(name="strategy", defaultValue="JPA_ENTITY") ResourceStrategy strategy) throws FileNotFoundException {
        List<JavaResource> javaTargets;
        if (!this.project.hasAllFacets(Arrays.asList(EJBFacet.class, PersistenceFacet.class))) {
            this.request.fire((Object)new InstallFacets(true, new Class[]{JTAFacet.class, EJBFacet.class, PersistenceFacet.class}));
        }
        if ((targets == null || targets.length < 1) && this.currentResource instanceof JavaResource) {
            targets = new JavaResource[]{(JavaResource)this.currentResource};
        }
        if ((javaTargets = this.selectTargets(out, (Resource<?>[])targets)).isEmpty()) {
            throw new IllegalArgumentException("Must specify a domain @Entity on which to operate.");
        }
        JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        RestGeneratedResources generatedResourcesEvent = new RestGeneratedResources();
        for (JavaResource jr : javaTargets) {
            JavaClass entity = (JavaClass)jr.getJavaSource();
            String idType = this.resolveIdType(entity);
            if (!Types.isBasicType((String)idType)) {
                ShellMessages.error((ShellPrintWriter)out, (String)("Skipped class [" + entity.getQualifiedName() + "] because @Id type [" + idType + "] is not supported by endpoint generation."));
                continue;
            }
            JavaClass resource = null;
            if (strategy.equals((Object)ResourceStrategy.JPA_ENTITY)) {
                resource = this.entityResourceGenerator.generateFrom(entity, idType, contentType, generatedResourcesEvent);
            } else if (strategy.equals((Object)ResourceStrategy.ROOT_AND_NESTED_DTO)) {
                resource = this.dtoResourceGenerator.generateFrom(entity, idType, contentType, generatedResourcesEvent);
            }
            generatedResourcesEvent.addToEntities(jr);
            if (!java.getJavaResource((JavaSource)resource).exists() || this.prompt.promptBoolean("Endpoint [" + resource.getQualifiedName() + "] already, exists. Overwrite?")) {
                generatedResourcesEvent.addToEndpoints(java.saveJavaSource((JavaSource)resource));
                ShellMessages.success((ShellPrintWriter)out, (String)("Generated REST endpoint for [" + entity.getQualifiedName() + "]"));
                continue;
            }
            ShellMessages.info((ShellPrintWriter)out, (String)("Aborted REST endpoint generation for [" + entity.getQualifiedName() + "]"));
        }
        if (!generatedResourcesEvent.getEntities().isEmpty()) {
            this.generatedEvent.fire((Object)generatedResourcesEvent);
        }
    }

    private String resolveIdType(JavaClass entity) {
        for (Member member : entity.getMembers()) {
            if (!member.hasAnnotation(Id.class)) continue;
            if (member instanceof Method) {
                return ((Method)member).getReturnType();
            }
            if (!(member instanceof Field)) continue;
            return ((Field)member).getType();
        }
        return "Object";
    }

    private List<JavaResource> selectTargets(PipeOut out, Resource<?>[] targets) throws FileNotFoundException {
        ArrayList<JavaResource> results = new ArrayList<JavaResource>();
        if (targets == null) {
            targets = new Resource[]{};
        }
        for (Resource<?> r : targets) {
            if (!(r instanceof JavaResource)) continue;
            JavaSource entity = ((JavaResource)r).getJavaSource();
            if (entity instanceof JavaClass) {
                if (entity.hasAnnotation(Entity.class)) {
                    results.add((JavaResource)r);
                    continue;
                }
                this.displaySkippingResourceMsg(out, entity);
                continue;
            }
            this.displaySkippingResourceMsg(out, entity);
        }
        return results;
    }

    private void displaySkippingResourceMsg(PipeOut out, JavaSource<?> entity) {
        if (!out.isPiped()) {
            ShellMessages.info((ShellPrintWriter)out, (String)("Skipped non-@Entity Java resource [" + entity.getQualifiedName() + "]"));
        }
    }
}

