/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.profiles;

import java.util.List;
import java.util.Properties;
import org.jboss.forge.maven.profiles.Profile;
import org.jboss.forge.maven.profiles.ProfileAdapter;
import org.jboss.forge.maven.profiles.ProfileImpl;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyRepository;

public class ProfileBuilder
implements Profile {
    private ProfileImpl profile;

    private ProfileBuilder(ProfileImpl profile) {
        this.profile = profile;
    }

    public static ProfileBuilder create() {
        return new ProfileBuilder(new ProfileImpl());
    }

    public static ProfileBuilder create(Profile profile) {
        if (profile instanceof ProfileImpl) {
            return new ProfileBuilder((ProfileImpl)profile);
        }
        if (profile instanceof ProfileBuilder) {
            return new ProfileBuilder(((ProfileBuilder)profile).profile);
        }
        throw new IllegalArgumentException("Profile of type '" + profile.getClass().getName() + "' is not supported");
    }

    @Override
    public String getId() {
        return this.profile.getId();
    }

    @Override
    public boolean isActiveByDefault() {
        return this.profile.isActiveByDefault();
    }

    @Override
    public List<Dependency> listDependencies() {
        return this.profile.listDependencies();
    }

    @Override
    public List<DependencyRepository> listRepositories() {
        return this.profile.listRepositories();
    }

    @Override
    public Properties getProperties() {
        return this.profile.getProperties();
    }

    public ProfileBuilder setId(String id) {
        this.profile.setId(id);
        return this;
    }

    public ProfileBuilder setActiveByDefault(boolean activeByDefault) {
        this.profile.setActivateByDefault(activeByDefault);
        return this;
    }

    public ProfileBuilder addDependency(Dependency dependency) {
        this.profile.listDependencies().add(dependency);
        return this;
    }

    public ProfileBuilder addRepository(DependencyRepository repository) {
        this.profile.listRepositories().add(repository);
        return this;
    }

    public ProfileBuilder addProperty(String key, String value) {
        this.profile.getProperties().setProperty(key, value);
        return this;
    }

    public org.apache.maven.model.Profile getAsMavenProfile() {
        return new ProfileAdapter(this.profile);
    }
}

